% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idx.R
\name{idx_add}
\alias{idx_add}
\title{Calculate the mean value of multiple items}
\usage{
idx_add(data, cols, newcol = NULL, negative = FALSE, clean = TRUE)
}
\arguments{
\item{data}{A dataframe.}

\item{cols}{A tidy selection of item columns.}

\item{newcol}{Name of the index as a character value.
Set to NULL (default) to automatically build a name
from the common column prefix, prefixed with "idx_".}

\item{negative}{If FALSE (default), negative values are recoded as missing values.}

\item{clean}{Prepare data by \link{data_clean}.}
}
\value{
The input tibble with an additional column that contains the index values.
The column contains the result of the alpha calculation in the attribute named "psych.alpha".
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
ds <- volker::chatgpt
volker::idx_add(ds, starts_with("cg_adoption"))
}
