% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_qtl.R
\name{data_effects}
\alias{data_effects}
\title{Get effects information}
\usage{
data_effects(
  qtl_info,
  effects,
  pheno.col = NULL,
  parents = NULL,
  lgs = NULL,
  groups = NULL,
  position = NULL,
  software,
  design = c("bar", "circle", "digenic")
)
}
\arguments{
\item{qtl_info}{data.frame with: LG - linkage group ID; Pos - position in linkage map (cM); 
Pheno - phenotype ID; Pos_lower - lower position of confidence interval; 
Pos_upper - upper position of the confidence interval; Pval - QTL p-value; h2 - herdability}

\item{effects}{data.frame with: pheno - phenotype ID; qtl.id - QTL ID; haplo - haplotype ID; effect - haplotype effect value}

\item{pheno.col}{integer identifying phenotype}

\item{parents}{vector with parents ID}

\item{lgs}{vector of integers with linkage group ID of selected QTL/s}

\item{groups}{vector of integers with selected linkage group ID}

\item{position}{vector of centimorgan positions of selected QTL/s}

\item{software}{character defining which software was used for QTL analysis. Currently support for: QTLpoly, diaQTL and polyqtlR.}

\item{design}{character defining the graphic design. Options: `bar` - barplot of the effects; 
`circle` - circular plot of the effects (useful to compare effects of different traits); 
`digenic` - heatmap plotting sum of additive effects (bottom diagonal) and digenic effects (top diagonal) when present}
}
\value{
ggplot graphic
}
\description{
Get effects information
}
\keyword{internal}
