% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/veg_aggregate.R
\name{veg_aggregate}
\alias{veg_aggregate}
\alias{veg_aggregate,formula,vegtable,function-method}
\title{Aggregating information into a data frame}
\usage{
veg_aggregate(object, data, FUN, ...)

\S4method{veg_aggregate}{formula,vegtable,`function`}(object, data, FUN, use_nas = TRUE, ...)
}
\arguments{
\item{object}{A formula indicating the variables used for the summary.
As in \code{\link[=crosstable]{crosstable()}}, the keywords \code{"TaxonName"} and \code{"AcceptedName"}
can be used to retrieve taxonomic names, where the second will set the
accepted name for names considered as synonyms.}

\item{data}{Either a data frame or an object of class \linkS4class{vegtable}.}

\item{FUN}{Function used to aggregate values.}

\item{...}{Further arguments passed to the function \code{\link[stats:aggregate]{stats::aggregate()}}.}

\item{use_nas}{Logical value indicating whether NA's should be included in
categorical variables or not.}
}
\value{
An object of class \link{data.frame}.
}
\description{
Compute summarizing tables from \linkS4class{vegtable} objects.
This function works in a similar way as \code{\link[=crosstable]{crosstable()}}.
}
\examples{
## Transform cover to percentage cover
veg <- cover_trans(x = Kenya_veg, to = "cover")

## Frequency of taxa per publication
atab <- veg_aggregate(object = cover ~ AcceptedName + REFERENCE, data = veg, FUN = length)
head(atab)

## Life form proportions per plot
atab <- veg_aggregate(object = cover ~ lf_behn_2018 + ReleveID, data = veg, FUN = sum)
head(atab)

}
\seealso{
\code{\link[=aggregate]{aggregate()}}
}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
