% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_se.R
\name{se.mean2}
\alias{se.mean2}
\title{Computes the standard error for a 2-group mean difference}
\usage{
se.mean2(m1, m2, sd1, sd2, n1, n2)
}
\arguments{
\item{m1}{estimated mean for group 1}

\item{m2}{estimated mean for group 2}

\item{sd1}{estimated standard deviation for group 1}

\item{sd2}{estimated standard deviation for group 2}

\item{n1}{sample size for group 1}

\item{n2}{sample size for group 2}
}
\value{
Returns a one-row matrix:
\itemize{
\item Estimate - estimated mean difference
\item SE - standard error
}
}
\description{
This function can be used to compute the standard error of a
2-group mean difference using the estimated means, estimated
standard deviations, and sample sizes. The effect size estimate
and standard error output from this function can be used as input
in the \link[vcmeta]{meta.ave.gen}, \link[vcmeta]{meta.lc.gen},
and \link[vcmeta]{meta.lm.gen} functions in applications where
compatible mean differences from a combination of 2-group
and paired-samples experiments are used in the meta-analysis.
Equality of variances is not asumed.
}
\examples{
se.mean2(21.9, 16.1, 3.82, 3.21, 40, 40)

#                   Estimate        SE
# Mean difference:       5.8 0.7889312


}
\references{
\insertRef{Snedecor1980}{vcmeta}
}
