% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-SVC_mle.R
\name{plot.SVC_mle}
\alias{plot.SVC_mle}
\title{Plotting Residuals of \code{SVC_mle} model}
\usage{
\method{plot}{SVC_mle}(x, which = 1:3, legend.pos = "bottomright", ...)
}
\arguments{
\item{x}{\code{\link{SVC_mle}} object}

\item{which}{numeric, indicating which of the 3 plots should be plotted}

\item{legend.pos}{character describing the position of the legend in the spatial residual plot, see \code{\link[graphics]{legend}}}

\item{...}{further arguments}
}
\value{
a maximum 3 plots
\itemize{
  \item Tukey-Anscombe plot, i.e. residuals vs. fitted
  \item QQ-plot
  \item spatial residuals
}
}
\description{
Method to plot the residuals from an \code{\link{SVC_mle}} object. For this, \code{save.fitted} has to be \code{TRUE} in \code{\link{SVC_mle_control}}.
}
\examples{
#' ## ---- toy example ----
## sample data
# setting seed for reproducibility
set.seed(123)
m <- 7
# number of observations
n <- m*m
# number of SVC
p <- 3
# sample data
y <- rnorm(n)
X <- matrix(rnorm(n*p), ncol = p)
# locations on a regular m-by-m-grid
locs <- expand.grid(seq(0, 1, length.out = m),
                    seq(0, 1, length.out = m))

## preparing for maximum likelihood estimation (MLE)
# controls specific to MLE
control <- SVC_mle_control(
  # initial values of optimization
  init = rep(0.1, 2*p+1),
  # using profile likelihood
  profileLik = TRUE
)

# controls specific to optimization procedure, see help(optim)
opt.control <- list(
  # number of iterations (set to one for demonstration sake)
  maxit = 1,
  # tracing information
  trace = 6
)

## starting MLE
fit <- SVC_mle(y = y, X = X, locs = locs,
               control = control,
               optim.control = opt.control)

## output: convergence code equal to 1, since maxit was only 1
summary(fit)

## plot residuals
# only QQ-plot
plot(fit, which = 2)

# all three plots next to each other
oldpar <- par(mfrow = c(1, 3))
plot(fit)
par(oldpar)

}
\seealso{
\code{\link[graphics]{legend}}  \link{SVC_mle}
}
\author{
Jakob Dambon
}
