% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitly_links.R
\name{bitly_user_metrics_referring_domains}
\alias{bitly_user_metrics_referring_domains}
\title{Get Metrics for a Bitlink by referring domains}
\usage{
bitly_user_metrics_referring_domains(
  bitlink = NULL,
  unit = "day",
  units = -1,
  size = 50,
  unit_reference = NULL,
  showRequestURL = FALSE
)
}
\arguments{
\item{bitlink}{- required, a Bitlink made of the domain and hash}

\item{unit}{- string | Default: "day", Enum: "minute" "hour" "day" "week" "month" | A unit of time}

\item{units}{- integer | Default: -1 | An integer representing the time units to
query data for. pass -1 to return all units of time.}

\item{size}{- string |  Default: 50 | The quantity of items to be be returned}

\item{unit_reference}{- string | An ISO-8601 timestamp, indicating the most recent time for
which to pull metrics. Will default to current time.}

\item{showRequestURL}{- an optional T/F value to whether show URL which has been
build and requested from server. For debug purposes, default FALSE.}
}
\value{
facet - string | One of "countries" "referrers" "referrers_by_domain"
"referring_domains" "referring_networks" "shorten_counts"
}
\description{
This endpoint will rollup the click counts to a referrer about a single Bitlink.
}
\examples{
\dontrun{
bitly_user_metrics_referring_domains(bitlink = "cnn.it/2HomWGB", unit = "month", units = -1,
size = 100)
}

}
\seealso{
See \url{https://dev.bitly.com/api-reference#getMetricsForBitlinkByReferringDomains}
}
