% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{system_log_entry}
\alias{system_log_entry}
\title{Add Log Entry}
\usage{
system_log_entry(cfg, entry)
}
\arguments{
\item{cfg}{ubiquity system object}

\item{entry}{string containing the log entry}
}
\value{
Boolean variable indicating success (\code{TRUE}) or failure (\code{FALSE})
}
\description{
Appends a specified line to the analysis log
}
\examples{
\donttest{
# Creating a system file from the mab_pk example
fr = system_new(file_name        = "system.txt", 
                system_file      = "mab_pk", 
                overwrite        = TRUE, 
                output_directory = tempdir())

# Building the system 
cfg = build_system(system_file  = file.path(tempdir(), "system.txt"),
      output_directory          = file.path(tempdir(), "output"),
      temporary_directory       = tempdir())

# Initialzing the log file
system_log_entry(cfg, "Text of log entry")
}
}
\keyword{internal}
