% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{prepare_figure}
\alias{prepare_figure}
\title{Make ggplot Figure Pretty}
\usage{
prepare_figure(
  purpose = "present",
  fo,
  y_tick_minor = FALSE,
  y_tick_major = FALSE,
  x_tick_minor = FALSE,
  x_tick_major = FALSE
)
}
\arguments{
\item{purpose}{either \code{"present"} (default), \code{"print"} or \code{"shiny"}}

\item{fo}{ggplot figure object}

\item{y_tick_minor}{Boolean value to control grid lines}

\item{y_tick_major}{Boolean value to control grid lines}

\item{x_tick_minor}{Boolean value to control grid lines}

\item{x_tick_major}{Boolean value to control grid lines}
}
\value{
ggplot object
}
\description{
Takes a ggplot object and alters the line thicknesses and makes
other cosmetic changes to make it more appropriate for exporting.
}
\examples{
library("ggplot2")
df = data.frame(x = seq(0.01,10,.01),
               y = seq(0.01,10,.01)^2)
p       = ggplot(df, aes(x=x, y=y)) + geom_line()
# pretty up the axes
p       = prepare_figure(fo=p, purpose="print")
# pretty log10 y-axis 
p_logy  = gg_log10_yaxis(fo=p)
# pretty log10 x-axis 
p_logx  = gg_log10_xaxis(fo=p)
# pretty log10 yx-axis 
p_logxy = gg_axis(fo=p)
}
