% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsvreq.R
\name{tsvreq}
\alias{tsvreq}
\title{Creator function for the \code{tsvreq} S3 class}
\usage{
tsvreq(ts, com, comnull, tsvr, wts)
}
\arguments{
\item{ts}{A vector of timescales}

\item{com}{A numeric vector of the same length as \code{ts} containing nonnegative quantities}

\item{comnull}{Another such}

\item{tsvr}{Another such}

\item{wts}{Another such}
}
\value{
\code{tsvreq} returns an object of class \code{tsvreq}. Slots are: 
\item{ts}{the input}
\item{com}{the input, equal to \code{comnull}*\code{tsvr}} 
\item{comnull}{the input}
\item{tsvr}{the input}
\item{wts}{the input}
}
\description{
The \code{tsvreq} (timescale-specific variance ratio equation) class is for storing 
functional equations based on a timescale-specific variance ratio. This is a general class 
from which other classes inherit (only \code{tsvreq_classic} at this point). \code{tsvreq} 
inherits from the \code{list} class.
}
\examples{
res<-tsvreq(ts=1:10,com=2*c(1:10),comnull=1:10,tsvr=rep(2,10),wts=rep(3,10))

}
\seealso{
\code{\link{tsvreq_methods}}, \code{\link{tsvreq_classic}}, \code{\link{vreq}}, 
\code{browseVignettes("tsvr")}
}
\author{
Shaopeng Wang, \email{shaopeng.wang@pku.edu.cn}; Lei Zhao, \email{lei.zhao@cau.edu.cn}; Daniel Reuman, \email{reuman@ku.edu}
}
