% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/start_ts_after_internal_nas.R
\name{start_ts_after_internal_nas}
\alias{start_ts_after_internal_nas}
\title{Start a Time Series after the Last Internal NA}
\usage{
start_ts_after_internal_nas(series)
}
\arguments{
\item{series}{on object of class ts}
}
\description{
Internal NAs can cause trouble for time series operations such as 
X-13-ARIMA SEATS seasonal adjustment. Often, internal NAs only occur at
at the beginning of a time series. Thus an easy solution to the problem 
is to discard the initial part of the data which contains the NA values. 
This way only a small part of the information is lost as opposed to 
not being able to seasonally adjust an entire series.
}
\examples{
ts1 <- 1:30
ts1[c(3,6)] <- NA
ts1 <- ts(ts1,start=c(2000,1),frequency = 4)
start_ts_after_internal_nas(ts1)
}
\seealso{
\code{\link{stripLeadingNAsFromTs}}, \code{\link{stripTrailingNAsFromTs}}
}
