% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ibased.R
\name{mean_i}
\alias{mean_i}
\title{Mean I statistic.}
\usage{
mean_i(phy)
}
\arguments{
\item{phy}{phylo object or ltable}
}
\value{
average I value across all nodes
}
\description{
The mean I value is defined for all nodes with at least 4 tips
connected, such that different topologies can be formed. Then, for each node,
I = (nm - nt/2) / (nt - 1 - nt/2), where nt is the total number of tips
descending from that node, nm is the daughter branch leading to most tips,
and nt/2 is the minimum size of the maximum branch, rounded up. Following
Purvis et al 2002, we perform a correction on I, where we correct I for
odd nt, such that I' = I * (nt - 1) / nt. This correction ensures that I
is independent of nt. We report the mean value across all I' (again,
following Purvis et al. 2002).
}
\references{
G. Fusco and Q. C. Cronk. A new method for evaluating the shape
of large phylogenies. Journal of Theoretical Biology, 1995.
doi: 10.1006/jtbi.1995.0136.
A. Purvis, A. Katzourakis, and P.-M. Agapow. Evaluating Phylogenetic Tree
Shape: Two Modifications to Fusco & Cronks Method. Journal of Theoretical
Biology, 2002. doi: 10.1006/jtbi.2001.2443.
}
