% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set-methods.R
\name{setPD}
\alias{setPD}
\title{Set the phylogenetic diversity}
\usage{
setPD(tree, val)
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{val}{new phylogenetic diversity}
}
\description{
Return a tree with the phylogenetic diversity altered.
}
\details{
Use this function to convert the phylogenetic diversity of a tree. For example,
you might want to convert the tree so the sum of all branches is 1. This function will achieve
that by modiyfing every branch, while maintaining their relative lengths.
}
\examples{
library(treeman)
tree <- randTree(10)
tree <- setPD(tree, val=1)
summary(tree)
}
\seealso{
\code{\link{setAge}}
\url{https://github.com/DomBennett/treeman/wiki/set-methods}
}
