% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc-methods.R
\name{calcDstMtrx}
\alias{calcDstMtrx}
\title{Calculate the distance matrix}
\usage{
calcDstMtrx(tree, ids, parallel = FALSE, progress = "none")
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{ids}{IDs of nodes/tips}

\item{parallel}{logical, make parallel?}

\item{progress}{name of the progress bar to use, see \code{\link{create_progress_bar}}}
}
\description{
Returns a distance matrix for specified ids of a tree.
}
\details{
The distance between every id in the tree is calculated by summing the
lengths of the branches that connect them. This can be useful for testing the distances
between trees, checking for evoltuionary isolated tips etc. Parallelizable.
}
\examples{
# checking the distance between two trees
library(treeman)
tree_1 <- randTree(10)
tree_2 <- randTree(10)
dmat1 <- calcDstMtrx(tree_1, tree_1['tips'])
dmat2 <- calcDstMtrx(tree_2, tree_2['tips'])
mdl <- cor.test(x=dmat1, y=dmat2)
as.numeric(1 - mdl$estimate)  # 1 - Pearson's r
}
\seealso{
\code{\link{calcDstBLD}}, \code{\link{calcDstRF}}, \code{\link{calcDstTrp}}
\url{https://github.com/DomBennett/treeman/wiki/calc-methods}
}
