% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update-methods.R
\name{addNdmtrx}
\alias{addNdmtrx}
\title{Add node matrix to a tree}
\usage{
addNdmtrx(tree, shared = FALSE, ...)
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{shared}{T/F, should the bigmatrix be shared? See bigmemory documentation.}

\item{...}{\code{as.big.matrix()} additional arguments}
}
\description{
Return tree with node matrix added.
}
\details{
The node matrix makes 'enquiry'-type computations faster:
determining node ages, number of descendants etc. But it takes up
large amounts of memory and has no impact on adding or removing tips.
Note, trees with the node matrix can not be written to disk using the
'serialization format' i.e. with \code{save} or \code{saveRDS}.
The matrix is generated with bigmemory's `as.big.matrix()`.
}
\examples{
# library(treeman)
tree <- randTree(10, wndmtrx=FALSE)
summary(tree)
tree <- addNdmtrx(tree)
summary(tree)
}
\seealso{
\code{\link{updateSlts}}, \code{\link{rmNdmtrx}},
\url{https://cran.r-project.org/package=bigmemory}
}
