% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tr_ernest.R
\name{tr_ernest}
\alias{tr_ernest}
\title{Amniote life history dataset}
\usage{
tr_ernest(read = TRUE, ...)
}
\arguments{
\item{read}{(logical) read in csv files. Default: \code{TRUE}}

\item{...}{Curl options passed on to [crul::HttpClient()]}
}
\value{
paths to the files (character) if \code{read=FALSE} or
a list of data.frame's if \code{read=TRUE}
}
\description{
Amniote life history dataset
}
\details{
When using this data, cite the paper:

Myhrvold, N. P., Baldridge, E., Chan, B., Sivam, D., Freeman, D. L. and
Ernest, S. K. M. (2015), An amniote life-history database to perform
comparative analyses with birds, mammals, and reptiles. Ecology, 96: 3109.
https://doi.org/10.1890/15-0846R.1

As well as the Dryad data package:

L. Freeman, Daniel; P. Myhrvold, Nathan; Chan, Benjamin; Sivam, Dhileep;
Ernest, S. K. Morgan; Baldridge, Elita (2016): Full Archive. figshare.
https://doi.org/10.6084/m9.figshare.3563457.v1
}
\examples{
\dontrun{
res <- tr_ernest()
res$data
res$references
res$sparse
res$range_count
}
}
\references{
https://doi.org/10.1890/15-0846R.1
https://doi.org/10.6084/m9.figshare.3563457.v1
}
