% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFreq.R
\name{plotFreq}
\alias{plotFreq}
\title{Plotting Counts of specified Wordgroups over Time (relative to Corpus)}
\usage{
plotFreq(object, id = names(object$text), type = c("docs", "words"),
  wordlist, link = c("and", "or"), wnames, ignore.case = FALSE,
  rel = FALSE, mark = TRUE, unit = "month", curves = c("exact",
  "smooth", "both"), smooth = 0.05, both.lwd, both.lty, main, xlab, ylab,
  ylim, col, legend = "topright", natozero = TRUE, file, ...)
}
\arguments{
\item{object}{\code{\link{textmeta}} object with strictly tokenized
\code{text} component (\code{character} vectors) - like a result of
\code{\link{cleanTexts}}}

\item{id}{\code{character} vector (default: \code{object$meta$id}) which IDs
specify the subcorpus}

\item{type}{\code{character} (default: \code{"docs"}) should counts/proportion
of documents, where every  \code{"docs"} or words \code{"words"} be plotted}

\item{wordlist}{list of \code{character} vectors. Every list element is an 'or'
link, every \code{character} string in a vector is linked by the argument
\code{link}. If \code{wordlist} is only a \code{character} vector it will be
coerced to a list of the same length as the vector (see \code{\link{as.list}}),
so that the argument \code{link} has no effect. Each \code{character} vector
as a list element represents one curve in the outcoming plot}

\item{link}{\code{character} (default: \code{"and"}) should the (inner)
\code{character} vectors of each list element be linked by an \code{"and"}
or an \code{"or"}}

\item{wnames}{\code{character} vector of same length as \code{wordlist}
- labels for every group of 'and' linked words}

\item{ignore.case}{\code{logical} (default: \code{FALSE}) option
from \code{\link{grepl}}.}

\item{rel}{\code{logical} (default: \code{FALSE}) should counts
(\code{FALSE}) or proportion (\code{TRUE}) be plotted}

\item{mark}{\code{logical} (default: \code{TRUE}) should years be marked by
vertical lines}

\item{unit}{\code{character} (default: \code{"month"}) to which unit should
dates be floored. Other possible units are \code{"bimonth"}, \code{"quarter"}, \code{"season"},
\code{"halfyear"}, \code{"year"}, for more units see \code{\link[lubridate]{round_date}}}

\item{curves}{\code{character} (default: \code{"exact"}) should \code{"exact"},
\code{"smooth"} curve or \code{"both"} be plotted}

\item{smooth}{\code{numeric} (default: \code{0.05}) smoothing parameter
which is handed over to \code{\link{lowess}} as \code{f}}

\item{both.lwd}{graphical parameter for smoothed values
if \code{curves = "both"}}

\item{both.lty}{graphical parameter for smoothed values
if \code{curves = "both"}}

\item{main}{\code{character} graphical parameter}

\item{xlab}{\code{character} graphical parameter}

\item{ylab}{\code{character} graphical parameter}

\item{ylim}{(default if \code{rel = TRUE}: \code{c(0, 1)}) graphical parameter}

\item{col}{graphical parameter, could be a vector. If \code{curves = "both"}
the function will for every wordgroup plot at first the exact and then the
smoothed curve - this is important for your col order.}

\item{legend}{\code{character} (default: "topright") value(s) to specify the
legend coordinates. If "none" no legend is plotted.}

\item{natozero}{\code{logical} (default: \code{TRUE}) should NAs be coerced
to zeros. Only has effect if \code{rel = TRUE}.}

\item{file}{\code{character} file path if a pdf should be created}

\item{...}{additional graphical parameters}
}
\value{
A plot.
Invisible: A dataframe with columns \code{date} and \code{wnames} - and
additionally columns \code{wnames_rel} for \code{rel = TRUE} - with the
counts (and proportion) of the given wordgroups.
}
\description{
Creates a plot of the counts/proportion of given wordgroups (\code{wordlist})
in the subcorpus. The counts/proportion can be calculated on document or word
level - with an 'and' or 'or' link - and additionally can be normalised by
a subcorporus, which could be specified by \code{id}.
}
\examples{
\donttest{
data(politics)
poliClean <- cleanTexts(politics)
plotFreq(poliClean, wordlist=c("obama", "bush"))
}
}
