% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{challengewins}
\alias{challengewins}
\title{challengewins}
\format{
This data frame contains the following columns:
\describe{
  \item{\code{season}}{Name of season}
  \item{\code{seasonNumber}}{Season number}
  \item{\code{series}}{Top Chef US (listed as US); Top Chef US Masters
                       (listed as US Masters); Top Chef Canada (listed
                       as Canada)}
  \item{\code{episode}}{Episode number}
  \item{\code{inCompetition}}{True / false for whether the Chef was still
                               in the competition at the time of the
                               challenge}
  \item{\code{chef}}{Name of chef}
  \item{\code{challengeType}}{Challenge type: qualifying challenge,
                             elimination, quickfire, sudden death quickfire,
                             quickfire elimination, battle of the sous
                             chefs}
  \item{\code{outcome}}{Result for each Chef in the competition for that
                       challenge}
  \item{\code{rating}}{Numeric rating provided to chefs in Top Chef US
                       Masters Seasons 1 and 2. Will be blank for all
                       other seasons.}
}
}
\source{
\url{https://en.wikipedia.org/wiki/Top_Chef}
}
\usage{
data(challengewins)
}
\description{
A dataset containing win and loss data for each chef in each episode
}
\examples{
library(dplyr)
library(tidyr)
challengewins \%>\%
  group_by(outcome) \%>\%
  summarise(n=n())
}
\keyword{datasets}
