% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-columns.R
\name{grid_columns_opts}
\alias{grid_columns_opts}
\title{Set global columns options}
\usage{
grid_columns_opts(
  grid,
  minWidth = NULL,
  resizable = NULL,
  frozenCount = NULL,
  frozenBorderWidth = NULL
)
}
\arguments{
\item{grid}{A table created with \code{\link[=datagrid]{datagrid()}}.}

\item{minWidth}{Minimum width of each columns.}

\item{resizable}{If set to true, resize-handles of each columns will be shown.}

\item{frozenCount}{The number of frozen columns.}

\item{frozenBorderWidth}{The value of frozen border width.
When the frozen columns are created by "frozenCount" option, the frozen border width set.}
}
\value{
A \code{datagrid} htmlwidget.
}
\description{
Set options for all columns.
}
\examples{
library(toastui)

# Set minimal width for columns
datagrid(countries) \%>\%
  grid_columns_opts(
    minWidth = 140
  )

# Freeze two first columns
datagrid(countries) \%>\%
  grid_columns_opts(
    minWidth = 140,
    frozenCount = 2,
    frozenBorderWidth = 5
  )
}
