      SUBROUTINE COVGENF(L,K,F,G,C,CN)
C
      INCLUDE 'timsac_f.h'
C
cc	PROGRAM COVGEN
C     PROGRAM 74.1.3. COVARIANCE GENERATION FROM GAIN FUNCTION.
C-----------------------------------------------------------------------
C     ** DESIGNED BY H. AKAIKE, THE INSTITUTE OF STATISTICAL MATHEMATICS
C     ** PROGRAMMED BY E. ARAHATA, THE INSTITUTE OF STATISTICAL MATHEMAT
C         TOKYO
C     ** DATE OF THE LATEST REVISION: MARCH 25, 1977
C     ** THIS PROGRAM WAS ORIGINALLY PUBLISHED IN
C         "TIMSAC-74 A TIME SERIES ANALYSIS AND CONTROL PROGRAM PACKAGE(1
C         BY H. AKAIKE, E. ARAHATA AND T. OZAKI, COMPUTER SCIENCE MONOGRA
C         NO.5, MARCH 1975, THE INSTITUTE OF STATISTICAL MATHEMATICS
C     ** FOR THE BASIC THEORY SEE "CANONICAL CORRELATION ANALYSIS OF TIM
C         AND THE USE OF AN INFORMATION CRITERION" BY H. AKAIKE, IN
C         "SYSTEM IDENTIFICATION: ADVANCES AND CASE STUDIES" R. K. MEHRA
C         D. G. LAINIOTIS EDS. ACADEMIC PRESS, NEW YORK, 1976
C-----------------------------------------------------------------------
C     THIS PROGRAM PRODUCES THE FOURIER TRANSFORM OF A POWER
C     GAIN FUNCTION IN THE FORM OF AN AUTOCOVARIANCE SEQUENCE.
C     THE GAIN FUNCTION IS DEFINED AS A RECTILINEAR FUNCTION WITH
C     THE VALUES G(I) SPECIFIED AT THE FREQUENCIES F(I),I=1,K.
C     THE OUTPUTS OF THIS PROGRAM ARE USED AS THE INPUTS TO THE CANONICA
C     CORRELATION ANALYSIS PROGRAM CANARM, TO REALIZE A FILTER WITH
C     THE DESIRED GAIN FUNCTION.
C
C     THE FOLLOWING INPUTS ARE REQUIRED:
C     (L,K): L, DESIRED MAXIMUM LAG OF COVARIANCE (AT MOST 1024)
C            K, NUMBER OF DATA POINTS (LESS THAN OR EQUAL TO 500)
C     (F(I),G(I))(I=1,K): F(I), FREQUENCY. BY DEFINITION F(1)=0.0 AND F(
C                           F(I)'S ARE ARRANGED IN INCREASING ORDER.
C                           G(I), POWER GAIN OF THE FILTER AT THE FREQUEN
C
C     OUTPUTS:
C     (N,LAGH): N=2048
C     C(I)(I=0,LAGH):
C
cc      !DEC$ ATTRIBUTES DLLEXPORT :: COVGENF
C
      PARAMETER (LMAX=1024)
cxx      IMPLICIT REAL*8 (O-Y)
cc      REAL*8 C(1025),CN(1025),CX0
cc      COMPLEX*16 A(2048)
cc      DIMENSION F(500),G(500)
cc      DATA F / 500*0.0 /, G / 500*0.0 /
cxx      REAL*8  C(L+1),CN(L+1),CX0
cxx      COMPLEX*16 A(LMAX*2)
cxx      REAL*8  F(K),G(K)
      INTEGER :: L, K
      REAL(8) :: F(K), G(K), C(L+1), CN(L+1)
      REAL(8) :: CX0, Q00, AN, BN, CM, Q1, Q2, Q3, Q4, Q25
      COMPLEX(kind(0d0)) :: A(LMAX*2)
C
C     INPUT / OUTPUT DATA FILE OPEN
cc      CHARACTER(100) DFNAM
cc      CALL SETWND
cc      DFNAM='covgen.out'
cc      CALL FLOPN3(DFNAM,NFL)
cc      IF (NFL.EQ.0) GO TO 999
C
      Q00=0.0D-00
C     INITIAL CONDITION INPUT
cc      READ(5,800) L,K
cc      WRITE(6,900) L,K
cc      DO  100 I=1,K
cc  100 READ(5,801) F(I),G(I)
cc      DO  101 I=1,K
cc  101 WRITE(6,901) F(I),G(I)
cc  105 N=2048
      N=LMAX*2
      N2P=11
cc      AN=2048.0
cc      NN=1023
      AN=N
      NN=LMAX-1
      DO  200 I=1,NN
      BN=I
      CM=BN/AN
      J=K
cc  106 IF(CM-F(J)) 107,108,108
  106 CONTINUE
      IF(CM-F(J) .GE. 0) GO TO 108
cxx  107 J=J-1
      J=J-1
      GO TO 106
  108 J1=J+1
      Q1=(F(J1)-CM)*G(J)
      Q2=(CM-F(J))*G(J1)
      Q3=F(J1)-F(J)
      Q4=(Q1+Q2)/Q3
      I1=I+1
      Q1=Q4
      A(I1)=DCMPLX(Q1,Q00)
      I2=N-I+1
cxx  200 A(I2)=A(I1)
      A(I2)=A(I1)
  200 CONTINUE
      Q25=G(1)
      A(1)=DCMPLX(Q25,Q00)
      Q25=G(K)
      A(NN+2)=DCMPLX(Q25,Q00)
C     FAST FOURIER TRANSFORM OF A
C     COMMON SUBROUTINE CALL
      CALL MIXRAD(A,N,N2P,+1)
      LAGH1=L+1
      DO  201 I=1,LAGH1
cxx  201 C(I)=DREAL(A(I))
      C(I)=DREAL(A(I))
  201 CONTINUE
C     C(I+1),I=0,L     ARE THE DESIRED AUTOCOVARIANCES.
C     NORMARIZED COVARIANCES ARE GIVEN AS CN(I+1),I=0,L.
      CX0=C(1)
C     COMMON SUBROUTINE CALL
      CALL CORNOM(C,CN,LAGH1,CX0,CX0)
cc      WRITE(6,902)
cc      DO  210 I=1,LAGH1
cc      J=I-1
cc  210 WRITE(6,903) J,C(I),CN(I)
cc      LAGH=LAGH1-1
cc      WRITE(7,800) N,LAGH
cc      WRITE(7,904) (C(I),I=1,LAGH1)
cc      CALL FLCLS3(NFL)
      RETURN
cxx  800 FORMAT(2I5)
cxx  801 FORMAT(2F10.5)
cxx  900 FORMAT(1H ,' PROGRAM 74.1.3. COVGEN: L=',I5,5X,'K=',I5/1H )
cxx  901 FORMAT(1H ,' FREQUENCY(',F10.5,')',20X,'DESIRED GAIN = ',F10.5)
cxx  902 FORMAT(//1H ,20X,'AUTO COVARIANCE',25X,
cxx     *'AUTO COVARIANCE NORMALIZED')
cxx  903 FORMAT(1H ,'LAG =',I5,5X,D20.10,31X,D20.10)
cxx  904 FORMAT(4D20.10)
      END
