% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-stl_diagnostics.R
\name{plot_stl_diagnostics}
\alias{plot_stl_diagnostics}
\title{Visualize STL Decomposition Features for One or More Time Series}
\usage{
plot_stl_diagnostics(
  .data,
  .date_var,
  .value,
  .facet_vars = NULL,
  .feature_set = c("observed", "season", "trend", "remainder", "seasadj"),
  .frequency = "auto",
  .trend = "auto",
  .message = TRUE,
  .facet_scales = "free",
  .line_color = "#2c3e50",
  .line_size = 0.5,
  .line_type = 1,
  .line_alpha = 1,
  .title = "STL Diagnostics",
  .x_lab = "",
  .y_lab = "",
  .interactive = TRUE
)
}
\arguments{
\item{.data}{A \code{tibble} or \code{data.frame} with a time-based column}

\item{.date_var}{A column containing either date or date-time values}

\item{.value}{A column containing numeric values}

\item{.facet_vars}{One or more grouping columns that broken out into \code{ggplot2} facets.
These can be selected using \code{tidyselect()} helpers (e.g \code{contains()}).}

\item{.feature_set}{The STL decompositions to visualize.
Select one or more of "observed", "season", "trend", "remainder", "seasadj".}

\item{.frequency}{Controls the seasonal adjustment (removal of seasonality).
Input can be either "auto", a time-based definition (e.g. "2 weeks"),
or a numeric number of observations per frequency (e.g. 10).
Refer to \code{\link[=tk_get_frequency]{tk_get_frequency()}}.}

\item{.trend}{Controls the trend component.
For STL, trend controls the sensitivity of the lowess smoother, which is used to remove the remainder.}

\item{.message}{A boolean. If \code{TRUE}, will output information related to automatic frequency
and trend selection (if applicable).}

\item{.facet_scales}{Control facet x & y-axis ranges. Options include "fixed", "free", "free_y", "free_x"}

\item{.line_color}{Line color.}

\item{.line_size}{Line size.}

\item{.line_type}{Line type.}

\item{.line_alpha}{Line alpha (opacity). Range: (0, 1).}

\item{.title}{Plot title.}

\item{.x_lab}{Plot x-axis label}

\item{.y_lab}{Plot y-axis label}

\item{.interactive}{If TRUE, returns a \code{plotly} interactive plot.
If FALSE, returns a static \code{ggplot2} plot.}
}
\value{
A \code{plotly} or \code{ggplot2} visualization
}
\description{
An interactive and scalable function for visualizing time series STL Decomposition.
Plots are available in interactive \code{plotly} (default) and static \code{ggplot2} format.
}
\details{
The \code{plot_stl_diagnostics()} function generates a Seasonal-Trend-Loess decomposition.
The function is "tidy" in the sense that it works
on data frames and is designed to work with \code{dplyr} groups.

\strong{STL method}:

The STL method implements time series decomposition using
the underlying \code{\link[stats:stl]{stats::stl()}}. The decomposition separates the
"season" and "trend" components from
the "observed" values leaving the "remainder".

\strong{Frequency & Trend Selection}

The user can control two parameters: \code{.frequency} and \code{.trend}.
\enumerate{
\item The \code{.frequency} parameter adjusts the "season" component that is removed
from the "observed" values.
\item The \code{.trend} parameter adjusts the
trend window (\code{t.window} parameter from \code{stl()}) that is used.
}

The user may supply both \code{.frequency}
and \code{.trend} as time-based durations (e.g. "6 weeks") or numeric values
(e.g. 180) or "auto", which automatically selects the frequency and/or trend
based on the scale of the time series.
}
\examples{
library(tidyverse)
library(timetk)

# ---- SINGLE TIME SERIES DECOMPOSITION ----
m4_hourly \%>\%
    filter(id == "H10") \%>\%
    plot_stl_diagnostics(
        date, value,
        # Set features to return, desired frequency and trend
        .feature_set = c("observed", "season", "trend", "remainder"),
        .frequency   = "24 hours",
        .trend       = "1 week",
        .interactive = FALSE)


# ---- GROUPS ----
m4_hourly \%>\%
    group_by(id) \%>\%
    plot_stl_diagnostics(
        date, value,
        .feature_set = c("observed", "season", "trend"),
        .interactive = FALSE)



}
