% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_methods.R
\name{slice}
\alias{slice}
\title{Subset rows using their positions}
\usage{
slice(.data, ..., .preserve = FALSE)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See *Methods*, below, for
more details.}

\item{...}{For `slice()`: <[`data-masking`][dplyr_data_masking]> Integer row
  values.

  Provide either positive values to keep, or negative values to drop.
  The values provided must be either all positive or all negative.
  Indices beyond the number of rows in the input are silently ignored.

  For `slice_helpers()`, these arguments are passed on to methods.


  If `n` is greater than the number of rows in the group (or `prop > 1`),
  the result will be silently truncated to the group size. If the
  `prop`ortion of a group size is not an integer, it is rounded down.}

\item{.preserve}{when `FALSE` (the default), the grouping structure
is recalculated based on the resulting data, otherwise it is kept as is.}
}
\value{
An object of the same type as `.data`. The output has the following
properties:

* Each row may appear 0, 1, or many times in the output.
* Columns are not modified.
* Groups are not modified.
* Data frame attributes are preserved.
}
\description{
`slice()` lets you index rows by their (integer) locations. It allows you
to select, remove, and duplicate rows. It is accompanied by a number of
helpers for common use cases:

* `slice_head()` and `slice_tail()` select the first or last rows.
* `slice_sample()` randomly selects rows.
* `slice_min()` and `slice_max()` select rows with highest or lowest values
  of a variable.

If `.data` is a [grouped_df], the operation will be performed on each group,
so that (e.g.) `slice_head(df, n = 5)` will select the first five rows in
each group.
}
\details{
Slice does not work with relational databases because they have no
intrinsic notion of row order. If you want to perform the equivalent
operation, use [filter()] and [row_number()].
}
\section{Methods}{

These function are **generic**s, which means that packages can provide
implementations (methods) for other classes. See the documentation of
individual methods for extra arguments and differences in behaviour.

Methods available in currently loaded packages:

* `slice()`: \Sexpr[stage=render,results=rd]{dplyr:::methods_rd("slice")}.
* `slice_head()`: \Sexpr[stage=render,results=rd]{dplyr:::methods_rd("slice_head")}.
* `slice_tail()`: \Sexpr[stage=render,results=rd]{dplyr:::methods_rd("slice_tail")}.
* `slice_min()`: \Sexpr[stage=render,results=rd]{dplyr:::methods_rd("slice_min")}.
* `slice_max()`: \Sexpr[stage=render,results=rd]{dplyr:::methods_rd("slice_max")}.
* `slice_sample()`: \Sexpr[stage=render,results=rd]{dplyr:::methods_rd("slice_sample")}.
}

\examples{

`\%>\%` = magrittr::`\%>\%`
pbmc_small \%>\% tidy \%>\% slice(1)
}
\seealso{
Other single table verbs: 
\code{\link{arrange}()},
\code{\link{filter}()},
\code{\link{mutate}()},
\code{\link{rename}()},
\code{\link{select}()},
\code{\link{summarise}()}
}
\concept{single table verbs}
