% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detvar.R
\name{InterventionVar}
\alias{InterventionVar}
\title{Intervention variables}
\usage{
InterventionVar(Y, date, type = c("P", "S", "R"), n.ahead = 0)
}
\arguments{
\item{Y}{an object of class \code{ts} used to determine the sample period and
frequency.}

\item{date}{the date of the event, c(year, month).}

\item{type}{a character indicating the type of intervention variables: (P)
pulse, (S) step, (R).}

\item{n.ahead}{number of additional observations to extend the sample period.}
}
\value{
An intervention variable, a 'ts' object.
}
\description{
\code{InterventionVar} creates an intervention variable to capture the effect
of an external event.
}
\examples{

Y <- seriesJ$Y
P58 <- InterventionVar(Y, date = 58, type = "P")

}
\references{
G. E. P. Box, G. C. Tiao, “Intervention Analysis with Applications to
Economic and Environmental Problems”, Journal of the American Statistical
Association, Vol. 70, No. 349. (Mar., 1975), pp. 70-79.
}
