% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_1_textSimilarity.R
\name{textDistance}
\alias{textDistance}
\title{Compute the semantic distance between two text variables.}
\usage{
textDistance(x, y, method = "euclidean", center = FALSE, scale = FALSE)
}
\arguments{
\item{x}{Word embeddings (from textEmbed).}

\item{y}{Word embeddings (from textEmbed).}

\item{method}{(character) Character string describing type of measure to be computed; default is
"euclidean" (see also measures from stats:dist() including "maximum", "manhattan", "canberra",
"binary" and "minkowski". It is also possible to use "cosine", which computes the cosine distance
(i.e., 1 - cosine(x, y)).}

\item{center}{(boolean; from base::scale) If center is TRUE then centering is done by subtracting
the embedding mean
(omitting NAs) of x from each of its dimension, and if center is FALSE, no centering is done.}

\item{scale}{(boolean; from base::scale) If scale is TRUE then scaling is done by dividing the
(centered) embedding dimensions by the standard deviation of the embedding if center is TRUE,
 and the root mean square otherwise.}
}
\value{
A vector comprising semantic distance scores.
}
\description{
Compute the semantic distance between two text variables.
}
\examples{
# Compute the semantic distance score between the embeddings
# from "harmonytext" and "satisfactiontext".

\dontrun{
distance_scores <- textDistance(
  x = word_embeddings_4$texts$harmonytext,
  y = word_embeddings_4$texts$satisfactiontext
)

# Show information about how distance_scores were constructed.

comment(distance_scores)
}
}
\seealso{
See  \code{\link{textSimilarity}} and \code{\link{textSimilarityNorm}}.
}
