% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract,felm-method}
\alias{extract,felm-method}
\alias{extract.felm}
\title{\code{\link{extract}} method for \code{felm} objects}
\usage{
\S4method{extract}{felm}(
  model,
  include.nobs = TRUE,
  include.rsquared = TRUE,
  include.adjrs = TRUE,
  include.fstatistic = FALSE,
  include.proj.stats = TRUE,
  include.groups = TRUE,
  ...
)
}
\arguments{
\item{model}{A statistical model object.}

\item{include.nobs}{Report the number of observations in the GOF block?}

\item{include.rsquared}{Report R^2 in the GOF block?}

\item{include.adjrs}{Report adjusted R^2 in the GOF block?}

\item{include.fstatistic}{Report the F-statistic in the GOF block?}

\item{include.proj.stats}{Include statistics for projected model in the GOF block?}

\item{include.groups}{Report the number of groups?}

\item{...}{Custom parameters, which are handed over to subroutines, in this
case to the \code{summary} method for the object.}
}
\description{
\code{\link{extract}} method for \code{felm} objects created by the
\code{\link[lfe]{felm}} function in the \pkg{lfe} package.
}
\author{
Christoph Riedl, Claudia Zucca, Oliver Reiter, Philip Leifeld
}
