% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/texreg.R
\name{knitreg}
\alias{knitreg}
\title{Flexibly choose the right table output format for use with \pkg{knitr}}
\usage{
knitreg(...)
}
\arguments{
\item{...}{Arguments to be handed over to the \link{texreg}, \link{htmlreg},
\link{screenreg}, or \link{matrixreg} function. See the respective help
page for details.}
}
\value{
A table as a \code{character} string in the respective output format.
}
\description{
Flexibly choose the right table output format for use with \pkg{knitr}.
}
\details{
This function automatically selects the right function (\link{texreg},
\link{screenreg}, \link{htmlreg}, or \link{matrixreg}) with the right set of
arguments for use with the \pkg{knitr} package, for example in RStudio. The
advantage of using this function with \pkg{knitr} is that the user does not
need to replace the \link{texreg}, \link{htmlreg} etc. function call in the
document when a different output format is selected.

\link{knitreg} works with...
\itemize{
  \item \R HTML documents (\code{.Rhtml} extension)
  \item \R Sweave documents (\code{.Rnw} extension) for PDF output via LaTeX,
    rendered using...
    \itemize{
      \item the \pkg{knitr} package
      \item the \pkg{Sweave} package
    }
  \item \R Markdown documents (\code{.Rmd} extension), rendered as...
    \itemize{
      \item HTML documents
      \item PDF documents
      \item Word documents
      \item Powerpoint presentations
      \item Presentations (\code{.Rpres} extension, not \code{.Rmd})
    }
  \item \R Notebooks, including preview
}

If Markdown and HTML rendering are selected, \link{htmlreg} arguments
\code{doctype = FALSE} and \code{star.symbol = "&#42;"} are set to enable
compatibility with Markdown. With \R HTML documents (but not Markdown) or
presentations (\code{.Rpres} extension), only \code{doctype = FALSE} is set.

For PDF/LaTeX documents, the \link{texreg} argument
\code{use.packages = FALSE} is set to suppress any package loading
instructions in the preamble. The user must load any packages manually in the
preamble of the document.

The \pkg{knitr} and \pkg{rmarkdown} packages must be installed for this
function to work.
}
\examples{
require("nlme")
model.1 <- lme(distance ~ age, data = Orthodont, random = ~ 1)
model.2 <- lme(distance ~ age + Sex, data = Orthodont, random = ~ 1)
knitreg(list(model.1, model.2), center = FALSE, caption = "", table = FALSE)

}
\seealso{
\code{\link{texreg-package}} \code{\link{extract}}

Other texreg: 
\code{\link{htmlreg}()},
\code{\link{huxtablereg}()},
\code{\link{matrixreg}()},
\code{\link{plotreg}()},
\code{\link{screenreg}()},
\code{\link{texreg}},
\code{\link{wordreg}()}
}
\author{
Philip Leifeld, with input from David Hugh-Jones
}
\concept{texreg}
