% Generated by roxygen2 (4.0.2): do not edit by hand
\name{equals_reference}
\alias{equals_reference}
\alias{expect_equal_to_reference}
\title{Expectation: is the object equal to a reference value stored in a file?}
\usage{
equals_reference(file, label = NULL, ...)

expect_equal_to_reference(object, file, ..., info = NULL, label = NULL,
  expected.label = NULL)
}
\arguments{
\item{file}{The file name used to store the object. Should have an "rds"
extension.}

\item{label}{For the full form, a label for the expected object, which is
used in error messages. Useful to override the default (which is based
on the file name), when doing tests in a loop. For the short-cut form,
the object label, which is computed from the deparsed object by default.}

\item{...}{other values passed to \code{\link{equals}}}

\item{object}{object to test}

\item{info}{extra information to be included in the message (useful when
writing tests in loops).}

\item{expected.label}{Equivalent of \code{label} for shortcut form.}
}
\description{
This expectation is equivalent to \code{\link{equals}}, except that the
expected value is stored in an RDS file instead of being specified
literally. This can be helpful when the value is necessarily complex. If
the file does not exist then it will be created using the value of the
specified object, and subsequent tests will check for consistency against
that generated value. The test can be reset by deleting the RDS file.
}
\examples{
\dontrun{
expect_equal_to_reference(1, "one.rds")
}
}
\seealso{
Other expectations: \code{\link{equals}},
  \code{\link{expect_equal}}; \code{\link{expect-compare}},
  \code{\link{expect_less_than}},
  \code{\link{expect_more_than}},
  \code{\link{is_less_than}}, \code{\link{is_more_than}};
  \code{\link{expect_equivalent}},
  \code{\link{is_equivalent_to}};
  \code{\link{expect_error}}, \code{\link{throws_error}};
  \code{\link{expect_false}}, \code{\link{expect_true}},
  \code{\link{is_false}}, \code{\link{is_true}};
  \code{\link{expect_identical}},
  \code{\link{is_identical_to}}; \code{\link{expect_is}},
  \code{\link{is_a}}; \code{\link{expect_match}},
  \code{\link{matches}}; \code{\link{expect_message}},
  \code{\link{shows_message}}; \code{\link{expect_named}},
  \code{\link{has_names}}; \code{\link{expect_null}},
  \code{\link{is_null}}; \code{\link{expect_output}},
  \code{\link{prints_text}}; \code{\link{expect_warning}},
  \code{\link{gives_warning}};
  \code{\link{takes_less_than}}
}

