% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_missed_doses.R
\name{count_missed_doses}
\alias{count_missed_doses}
\alias{s_count_nonmissing}
\alias{s_count_missed_doses}
\alias{a_count_missed_doses}
\title{Counting Missed Doses}
\usage{
s_count_nonmissing(x)

s_count_missed_doses(x, thresholds, .N_col)

a_count_missed_doses(x, thresholds, .N_col)

count_missed_doses(
  lyt,
  vars,
  var_labels = vars,
  show_labels = "visible",
  ...,
  table_names = vars,
  .stats = NULL,
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL
)
}
\arguments{
\item{x}{(\code{numeric})\cr vector of numbers we want to analyze.}

\item{thresholds}{(vector of \code{count})\cr number of missed doses the patients at least had.}

\item{.N_col}{(\code{count})\cr row-wise N (row group count) for the group of observations being analyzed
(i.e. with no column-based subsetting) that is passed by \code{rtables}.}

\item{lyt}{(\code{layout})\cr input layout where analyses will be added to.}

\item{vars}{(\code{character})\cr variable names for the primary analysis variable to be iterated over.}

\item{var_labels}{(\code{character})\cr character for label.}

\item{show_labels}{(\code{string})\cr label visibility: one of "default", "visible" and "hidden".}

\item{...}{additional arguments for the lower level functions.}

\item{table_names}{(\code{character})\cr this can be customized in case that the same \code{vars} are analyzed multiple times,
to avoid warnings from \code{rtables}.}

\item{.stats}{(\code{character})\cr statistics to select for the table.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}
}
\value{
\itemize{
\item \code{s_count_nonmissing()} returns the statistic \code{n} which is the count of non-missing values in \code{x}.
}

\itemize{
\item \code{s_count_missed_doses()} returns the statistics \code{n} and \code{count_fraction} with one element for each threshold.
}

\itemize{
\item \code{a_count_missed_doses()} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}

\itemize{
\item \code{count_missed_doses()} returns a layout object suitable for passing to further layouting functions,
or to \code{\link[rtables:build_table]{rtables::build_table()}}. Adding this function to an \code{rtable} layout will add formatted rows containing
the statistics from \code{s_count_missed_doses()} to the table layout.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

These are specific functions to count patients with missed doses. The difference to \code{\link[=count_cumulative]{count_cumulative()}} is
mainly the special labels.
}
\section{Functions}{
\itemize{
\item \code{s_count_nonmissing()}: Statistics function to count non-missing values.

\item \code{s_count_missed_doses()}: Statistics function to count patients with missed doses.

\item \code{a_count_missed_doses()}: Formatted analysis function which is used as \code{afun}
in \code{count_missed_doses()}.

\item \code{count_missed_doses()}: Layout-creating function which can take statistics function arguments
and additional format arguments. This function is a wrapper for \code{\link[rtables:analyze]{rtables::analyze()}}.

}}
\examples{
set.seed(1)
x <- c(sample(1:10, 10), NA)

library(dplyr)

anl <- tern_ex_adsl \%>\%
  distinct(STUDYID, USUBJID, ARM) \%>\%
  mutate(
    PARAMCD = "TNDOSMIS",
    PARAM = "Total number of missed doses during study",
    AVAL = sample(0:20, size = nrow(tern_ex_adsl), replace = TRUE),
    AVALC = ""
  )

basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  add_colcounts() \%>\%
  count_missed_doses("AVAL", thresholds = c(1, 5, 10, 15), var_labels = "Missed Doses") \%>\%
  build_table(anl, alt_counts_df = tern_ex_adsl)

}
\seealso{
Relevant description function \code{\link[=d_count_missed_doses]{d_count_missed_doses()}}.
}
\keyword{internal}
