% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pd_mods.R
\name{inv_emax_eleveld}
\alias{inv_emax_eleveld}
\title{Inverse Emax function}
\usage{
inv_emax_eleveld(pdresp, pars)
}
\arguments{
\item{pdresp}{PD response values}

\item{pars}{Named vector of parameter values with names (c50,gamma,E0,Emx).}
}
\description{
Inverse of Emax function used by Eleveld population PK model.
}
\examples{
pars_emax_eleveld <- c(c50 = 1.5, gamma = 1.47, gamma2 = 1.89, e0 = 100, emx = 100)
ce_seq <- seq(0,4,0.1)
all.equal(inv_emax_eleveld(emax_eleveld(ce_seq, pars_emax_eleveld), pars_emax_eleveld), ce_seq)
}
