% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxo_fuzzy_match.R
\name{taxo_fuzzy_match}
\alias{taxo_fuzzy_match}
\title{taxo_fuzzy_match}
\usage{
taxo_fuzzy_match(name, master, dist = 2)
}
\arguments{
\item{name}{Name to search}

\item{master}{List of names}

\item{dist}{Distance tolerance, Default: 2}
}
\value{
Matched name, string distance and original name. Null if not found.
}
\description{
Fuzzy matching with names
}
\details{
Fuzzy matching with names in the master list and return best match.
}
\examples{
\donttest{
master <- data.frame("canonical" = c("Abrothrix longipilis",
                                    "Acodon hirtus",
                                    "Akodon longipilis apta",
                                    "Akodon longipilis castaneus",
                                    "Chroeomys jelskii",
                                    "Acodon jelskii pyrrhotis"),
                    stringsAsFactors = FALSE)
 taxo_fuzzy_match("Acodon hirta",master)
}
}
\seealso{
Other Name functions: 
\code{\link{build_gen_syn}()},
\code{\link{cast_canonical}()},
\code{\link{cast_scientificname}()},
\code{\link{check_scientific}()},
\code{\link{expand_name}()},
\code{\link{get_accepted_names}()},
\code{\link{guess_taxo_rank}()},
\code{\link{list_higher_taxo}()},
\code{\link{melt_canonical}()},
\code{\link{melt_scientificname}()},
\code{\link{resolve_names}()}
}
\concept{Name functions}
