% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxo2DwC.R
\name{taxo2DwC}
\alias{taxo2DwC}
\title{Taxolist to Darwin Core (DwC)}
\usage{
taxo2DwC(taxolist, verbose = TRUE)
}
\arguments{
\item{taxolist}{taxolist}

\item{verbose}{verbose output, Default: TRUE}
}
\value{
returns a taxonomic list in DwC format
}
\description{
Converts a taxolist to Darwin Core format
}
\details{
Converts a taxolist to Darwin Core format
}
\examples{
\donttest{
mytaxo <- data.frame("id" = c(1,2,3,4,5,6,7),
                    "canonical" = c("Hypochlorosis ancharia",
                                    "Hypochlorosis tenebrosa",
                                    "Pseudonotis humboldti",
                                    "Myrina ancharia",
                                    "Hypochlorosis ancharia tenebrosa",
                                    "Hypochlorosis ancharia obiana",
                                    "Hypochlorosis lorquinii"),
                     "family" = c("Lycaenidae", "Lycaenidae", "Lycaenidae",
                                  "Lycaenidae", "Lycaenidae", "Lycaenidae",
                                  "Lycaenidae"),
                    "accid" = c(0,1,1,1,0,0,0),
                    "source" = c("itis","itis","wiki","wiki","itis",
                                 "itis","itis"),
                    stringsAsFactors = FALSE)
mysynlst <- taxo2DwC(mytaxo)
}
}
\seealso{
Other List functions: 
\code{\link{DwC2taxo}()},
\code{\link{cast_cs_field}()},
\code{\link{compact_ids}()},
\code{\link{get_synonyms}()},
\code{\link{match_lists}()},
\code{\link{melt_cs_field}()},
\code{\link{merge_lists}()},
\code{\link{syn2taxo}()},
\code{\link{synonymize_subspecies}()},
\code{\link{taxo2doc}()},
\code{\link{taxo2syn}()},
\code{\link{wiki2taxo}()}
}
\concept{List functions}
