% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synonymize_subspecies.R
\name{synonymize_subspecies}
\alias{synonymize_subspecies}
\title{Convert all subspecies into synonyms of the species}
\usage{
synonymize_subspecies(master, return_unmatched = FALSE, verbose = TRUE)
}
\arguments{
\item{master}{List of names with a field named canonical}

\item{return_unmatched}{If the return values should be unmatched (orphan)
subspecies records. Default: FALSE}

\item{verbose}{display process messages, Default: TRUE}
}
\value{
Same list of names with id and accid fields added (or data updated
the fields exists) with all subspecies linked to the species names as
synonyms
}
\description{
used in generating master lists
}
\details{
While dealing with taxonomic names only at species level,
to take advantage of sub-specific names already available in the lists
are sometimes treated as synonyms of the names at species rank. To
convert all the subspecies names as synonyms this function is very handy.
This function will add id, accid and taxonrank columns ro return data if
missing from original data.
}
\examples{
\donttest{
master <- data.frame("id" = c(1,2,3,4,5,6,7),
                    "canonical" = c("Hypochlorosis ancharia",
                                     "Hypochlorosis tenebrosa",
                                     "Pseudonotis humboldti",
                                     "Myrina ancharia ancharia",
                                     "Hypochlorosis ancharia tenebrosa",
                                     "Hypochlorosis ancharia obiana",
                                     "Hypochlorosis lorquinii"),
                     "family" = c("Lycaenidae", "Lycaenidae", "Lycaenidae",
                                  "Lycaenidae", "Lycaenidae", "Lycaenidae",
                                  "Lycaenidae"),
                     "accid" = c(0,1,1,0,0,0,0),
                     "source" = c("itis","itis","wiki","wiki","itis",
                                  "itis","itis"),
                     stringsAsFactors = FALSE)

synonymize_subspecies(master)
synonymize_subspecies(master,return_unmatched = TRUE)
}
}
\seealso{
Other List functions: 
\code{\link{DwC2taxo}()},
\code{\link{cast_cs_field}()},
\code{\link{compact_ids}()},
\code{\link{get_synonyms}()},
\code{\link{match_lists}()},
\code{\link{melt_cs_field}()},
\code{\link{merge_lists}()},
\code{\link{syn2taxo}()},
\code{\link{taxo2DwC}()},
\code{\link{taxo2doc}()},
\code{\link{taxo2syn}()},
\code{\link{wiki2taxo}()}
}
\concept{List functions}
