% Generated by roxygen2 (4.0.1): do not edit by hand
\name{covMatSurv}
\alias{covMatSurv}
\title{Covariance matrix for survival data}
\usage{
covMatSurv(t, n, e, n1)
}
\arguments{
\item{t}{time}

\item{n}{number at risk}

\item{e}{number of events}

\item{n1}{number at risk (by predictor).
\cr
If \eqn{2} groups, should be given as a \code{vector} with
the number at risk for group \eqn{1}.
\cr
If \eqn{\geq 2}{>=2} groups, a \code{matrix} with one column for each group.}
}
\value{
An \code{array}. The first two dimensions = number of groups.
This is the square matrix below.
\cr
The third dimension is the number of observations (time points).
\cr \cr
Where there are \eqn{2} groups, the resulting sparse square matrix
(i.e. the non-diagonal elements are \eqn{0})
at time \eqn{i} has diagonal elements:
 \deqn{v_i = - \frac{n_{0i} n_{1i} e_i (n_i-e_i)}{n_i^2(n_i-1)}}{
       v(i) = - n0(i).n1(i).e(i).(n(i)-e(i)) / n(i)^2.(n(i) -1)}
where \eqn{n_1}{n1} is the number at risk in group \eqn{1}.
\cr \cr
For \eqn{\geq 2}{>=2} groups, the resulting square matrix has diagonal elements:
\deqn{ v_{kki} = \frac{n_{ki}(n_i-n_{ki})e_i(n_i-e_i)}{n_i^2(n_i-1)}}{
       v[k,k,i] = n[k](i).[n(i) - n[k](i)].e(i).[n(i) -e(i)] / n(i)^2.(n(i)-1)}
and off diagonal elements:
\deqn{ v_{kli} = \frac{ -n_{ki}n_{li} e_i(n_i-e_i)}{n_i^2(n_i-1)}}{
       v[k,l,i] = - n[k](i).n[l](i).e(i).[n(i)-e(i)] / n(i)^2.[n(i)-1]}
}
\description{
Gives variance-covariance matrix for comparing survival
data for two or more groups.
\cr
Inputs are vectors corresponding to observations at a set of discrete
time points for right censored data, except for \eqn{n1},
the no. at risk by predictor.
\cr
This should be specified as a vector for one group,
otherwise as a matrix with each column corresponding to a group.
}
\examples{
data(tneKidney)
covMatSurv(t=tneKidney$t, n=tneKidney$n, e=tneKidney$e, n1=tneKidney$n_1)
}
\seealso{
Called by \code{\link{comp}}
}
\keyword{survival}

