% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui.R
\name{style_pkg}
\alias{style_pkg}
\title{Prettify R source code}
\usage{
style_pkg(pkg = ".", ..., style = tidyverse_style,
  transformers = style(...), filetype = "R",
  exclude_files = "R/RcppExports.R")
}
\arguments{
\item{pkg}{Path to a (subdirectory of an) R package.}

\item{...}{Arguments passed on to the \code{style} function.}

\item{style}{A function that creates a style guide to use, by default
\code{\link[=tidyverse_style]{tidyverse_style()}} (without the parentheses). Not used
further except to construct the argument \code{transformers}. See
\code{\link[=style_guides]{style_guides()}} for details.}

\item{transformers}{A set of transformer functions. This argument is most
conveniently constructed via the \code{style} argument and \code{...}. See
'Examples'.}

\item{filetype}{Vector of file extensions indicating which filetypes should
be styled. Case is ignored, and the \code{.} is optional, e.g. \code{c(".R", ".Rmd")}
or \code{c("r", "rmd")}.}

\item{exclude_files}{Character vector with paths to files that should be
excluded from styling.}
}
\description{
Performs various substitutions in all \code{.R} files in a package
(code and tests).
Carefully examine the results after running this function!
}
\section{Warning}{

This function overwrites files (if styling results in a change of the
code to be formatted). It is strongly suggested to only style files
that are under version control or to create a backup copy.
}

\section{Value}{

Invisibly returns a data frame that indicates for each file considered for
styling whether or not it was actually changed.
}

\examples{
\dontrun{

style_pkg(style = tidyverse_style, strict = TRUE)
style_pkg(
  scope = "line_breaks",
  math_token_spacing = specify_math_token_spacing(zero = "'+'")
)
}
}
\seealso{
Other stylers: \code{\link{style_dir}},
  \code{\link{style_file}}, \code{\link{style_text}},
  \code{\link{styler_addins}}
}
