% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{straw}
\alias{straw}
\title{Straw Quick Dump}
\usage{
straw(norm, fname, chr1loc, chr2loc, unit, binsize, matrix = "observed")
}
\arguments{
\item{norm}{Normalization to apply. Must be one of NONE/VC/VC_SQRT/KR.
VC is vanilla coverage, VC_SQRT is square root of vanilla coverage, and KR is Knight-Ruiz or
Balanced normalization.}

\item{fname}{path to .hic file}

\item{chr1loc}{first chromosome location}

\item{chr2loc}{second chromosome location}

\item{unit}{BP (BasePair) or FRAG (FRAGment)}

\item{binsize}{The bin size. By default, for BP, this is one of <2500000, 1000000, 500000,
250000, 100000, 50000, 25000, 10000, 5000> and for FRAG this is one of <500, 200,
100, 50, 20, 5, 2, 1>.}

\item{matrix}{Type of matrix to output. Must be one of observed/oe/expected.
observed is observed counts, oe is observed/expected counts, expected is expected counts.}
}
\value{
Data.frame of a sparse matrix of data from hic file. x,y,counts
}
\description{
fast C++ implementation of dump. Not as fully featured as the
Java version. Reads the .hic file, finds the appropriate matrix and slice
of data, and outputs as data.frame in sparse upper triangular format.
Currently only supporting matrices.
}
\details{
Usage: straw <NONE/VC/VC_SQRT/KR> <hicFile(s)> <chr1>[:x1:x2] <chr2>[:y1:y2] <BP/FRAG> <binsize> [observed/oe/expected]
}
\examples{
straw("NONE", system.file("extdata", "test.hic", package = "strawr"), "1", "1", "BP", 2500000)
}
