% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_functions.R
\name{strata_match}
\alias{strata_match}
\title{Strata Match}
\usage{
strata_match(object, propensity = NULL, k = 1)
}
\arguments{
\item{object}{a strata object}

\item{propensity}{(optional) formula for propensity score.  If left
blank, all columns of the dataset will be used as covariates (except
outcome, treatment and stratum)}

\item{k}{numeric, the number of control individuals to be matched to each
treated individual}
}
\value{
a named factor with matching assignments
}
\description{
Match within strata in series using optmatch.  Requires optmatch package to
be installed.
}
\examples{
# make a sample data set
set.seed(1)
dat <- make_sample_data(n = 75)

# stratify with auto_stratify
a.strat <- auto_stratify(dat, "treat", outcome ~ X2, size = 25)

# 1:1 match based on propensity formula: treat ~ X1 + X2
strata_match(a.strat, propensity = treat ~ X1 + X2, k = 1)
}
