% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simdata_cont.R
\name{simdata_cont2}
\alias{simdata_cont2}
\title{Multi-dimensional simulation function for continuous trait.
Similar to simdata_cont(...) but much faster.}
\usage{
simdata_cont2(N = 10, a = -0.05, f1 = 80, Q = 2e-08, f = 80, b = 5,
  mu0 = 1e-05, theta = 0.08, ystart = 80, tstart = 30, tend = 105,
  dt = 1, sd0 = 1)
}
\arguments{
\item{N}{Number of individuals.}

\item{a}{A k by k matrix, which characterize the rate of the adaptive response.}

\item{f1}{A particular state, which if a deviation from the normal (or optimal). This is a vector with length of k.}

\item{Q}{A matrix k by k, which is a non-negative-definite symmetric matrix.}

\item{f}{A vector-function (with length k) of the normal (or optimal) state.}

\item{b}{A diffusion coefficient, k by k matrix.}

\item{mu0}{mortality at start period of time.}

\item{theta}{A displacement coefficient of the Gompertz function.}

\item{ystart}{A vector with length equal to number of dimensions used, defines starting values of covariates.}

\item{tstart}{A number that defines starting time (30 by default).}

\item{tend}{A number, defines final time (105 by default).}

\item{dt}{A discrete step size between two observations. A random uniform value is then added to this step size.}

\item{sd0}{a standard deviation for modelling the next covariate value.}
}
\value{
A table with simulated data.
}
\description{
Multi-dimensional simulation function for continuous trait.
Similar to simdata_cont(...) but much faster.
}
\examples{
library(stpm)
dat <- simdata_cont2(N=50)
head(dat)

}
\references{
Yashin, A.I. et al (2007). Stochastic model for analysis of longitudinal data on aging 
and mortality. Mathematical Biosciences, 208(2), 538-551.<DOI:10.1016/j.mbs.2006.11.006>.
}

