% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot.svpredict}
\alias{plot.svpredict}
\title{Graphical Summary of the Posterior Predictive Distribution}
\usage{
\method{plot}{svpredict}(x, quantiles = c(0.05, 0.25, 0.5, 0.75, 0.95), ...)
}
\arguments{
\item{x}{\code{svpredict} or \code{svlpredict} object.}

\item{quantiles}{Which quantiles to plot? Defaults to
\code{c(.05, .25, .5, .75, .95)}.}

\item{\dots}{further arguments are passed on to the invoked
\code{\link[stats]{ts.plot}} or \code{\link[graphics]{boxplot}} function.}
}
\value{
Called for its side effects. Returns argument \code{x} invisibly.
}
\description{
\code{plot.svpredict} and \code{plot.svlpredict} generate some plots
visualizing the posterior predictive distribution of future volatilites and
future observations.
}
\note{
Note that \code{svpredict} or \code{svlpredict} objects can also be
used within \code{\link{plot.svdraws}} for a possibly more useful
visualization. See the examples in \code{\link{predict.svdraws}} and
those below for use cases.
}
\examples{

## Simulate a short and highly persistent SV process
sim <- svsim(100, mu = -10, phi = 0.99, sigma = 0.1)

## Obtain 5000 draws from the sampler (that's not a lot)
draws <- svsample(sim$y, draws = 5000, burnin = 1000)

## Predict 10 steps ahead
pred <- predict(draws, 10)

## Visualize the predicted distributions
plot(pred)

## Plot the latent volatilities and some forecasts
plot(draws, forecast = pred)

}
\seealso{
Other plotting: 
\code{\link{paradensplot}()},
\code{\link{paratraceplot.svdraws}()},
\code{\link{paratraceplot}()},
\code{\link{plot.svdraws}()},
\code{\link{volplot}()}

Other plotting: 
\code{\link{paradensplot}()},
\code{\link{paratraceplot.svdraws}()},
\code{\link{paratraceplot}()},
\code{\link{plot.svdraws}()},
\code{\link{volplot}()}
}
\concept{plotting}
\keyword{hplot}
