% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{test.prop.ps}
\alias{test.prop.ps}
\title{Hypothesis test for a paired-samples proportion difference}
\usage{
test.prop.ps(f00, f01, f10, f11)
}
\arguments{
\item{f00}{number participants with y = 0 and x = 0}

\item{f01}{number participants with y = 0 and x = 1}

\item{f10}{number participants with y = 1 and x = 0}

\item{f11}{number participants with y = 1 and x = 1}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - ML estimate of proportion difference
\item z - z test statistic
\item p - p-value
}
}
\description{
Computes a continuity-corrected McNemar test for equality of proportions
in a paired-samples design. This function requires the frequency counts
from a 2 x 2 contingency table for two paired dichotomous measurements.
}
\examples{
test.prop.ps(156, 96, 68, 80)

# Should return:
#      Estimate        z          p
# [1,]     0.07 2.108346 0.03500109


}
\references{
\insertRef{Snedecor1980}{statpsych}
}
