% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{ci.theil}
\alias{ci.theil}
\title{Theil-Sen estimate and confidence interval for slope}
\usage{
ci.theil(alpha, y, x)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{y}{vector of response variable scores}

\item{x}{vector of predictor variable scores (paired with y)}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - Theil-Sen estimate of population slope
\item SE - approximate standard error
\item LL - lower limit of confidence interval
\item UL - upper limit of confidence interval
}
}
\description{
Computes a Theil-Sen estimate and distribution-free confidence interval
for the slope of a simple linear regression model. An approximate
standard error is recovered from the confidence interval.
}
\examples{
y <- c(21, 4, 9, 12, 35, 18, 10, 22, 24, 1, 6, 8, 13, 16, 19)
x <- c(67, 28, 30, 28, 52, 40, 25, 37, 44, 10, 14, 20, 28, 40, 51)
ci.theil(.05, y, x)

# Should return:
#      Estimate        SE        LL   UL
# [1,]      0.5 0.1085927 0.3243243 0.75


}
\references{
\insertRef{Hollander1999}{statpsych}
}
