% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detectSingleOutMaize.R
\name{detectSingleOutMaize}
\alias{detectSingleOutMaize}
\title{detectSingleOutMaize}
\usage{
detectSingleOutMaize(
  TP,
  timeBeforeTrt,
  trait1 = "Biomass_Estimated",
  trait2 = "Height_Estimated",
  trait3 = "phyllocron",
  thr = 0.95
)
}
\arguments{
\item{TP}{An object of class TP.}

\item{timeBeforeTrt}{A character or numeric value indicating the date just
before treatment in the experiment. When using a character string to
reference a time point, the value has to be an exact match to one of the
existing timePoints. When using a number it will be matched by its number
("timeNumber") in the timePoints attribute of the TP object.}

\item{trait1}{A character vector indicating the first trait to model in TP.}

\item{trait2}{A character vector indicating the second trait to model in TP.}

\item{trait3}{A character vector indicating the third trait to model in TP.}

\item{thr}{A numeric value indicating the threshold.}
}
\value{
A list with three data.frames, \code{modDat} containing the
data used for fitting the models, \code{smallPlants} containing the plants
identified as small plants and \code{bigPlants} containing the plants
identified as big plants.
}
\description{
Function to detect plant outliers in a temporal lattice experiment on Maize
which can be extended to other experiment types.
The criteria needs three phenotypes (ex for maize: the estimated biomass,
plant height and phyllocron)
\describe{
\item{plants are identified as "small outlier plant"}{if for biomass AND
phyllocron \eqn{res_i < \mu_{res} - qnorm(threshold) * sd_{res}}}
\item{plants are identified as "big outlier plant"}{ if for biomass AND
plant height \eqn{res_i > \mu_{res} + qnorm(threshold) * sd_{res}}}
}
}
\examples{
\donttest{
## Create a TP object containing the data from the PhenoArch.
phenoTParch <- createTimePoints(dat = PhenoarchDat1,
                                experimentName = "Phenoarch",
                                genotype = "geno",
                                timePoint = "Time",
                                plotId = "pos",
                                rowNum = "Row",
                                colNum = "Col")
singleOutMaize <- detectSingleOutMaize(phenoTParch,
                                       timeBeforeTrt = "2017-04-27",
                                       trait1 = "Biomass_Estimated",
                                       trait2 = "Height_Estimated",
                                       trait3 = "phyllocron",
                                       thr = 0.95)
}

}
\seealso{
Other functions for detecting outliers for single observations: 
\code{\link{detectSingleOut}()},
\code{\link{plot.singleOut}()},
\code{\link{removeSingleOut}()}
}
\concept{functions for detecting outliers for single observations}
