% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gxeVarComp.R
\name{gxeVarComp}
\alias{gxeVarComp}
\title{Mixed model analysis of GxE table of means}
\usage{
gxeVarComp(
  TD,
  trials = names(TD),
  trait,
  engine = c("lme4", "asreml"),
  locationYear = FALSE,
  nestingFactor = NULL,
  regionLocationYear = FALSE,
  useWt = FALSE,
  diagnostics = FALSE
)
}
\arguments{
\item{TD}{An object of class \code{\link{TD}}.}

\item{trials}{A character string specifying the trials to be analyzed. If
not supplied, all trials are used in the analysis.}

\item{trait}{A character string specifying the trait to be analyzed.}

\item{engine}{A character string specifying the engine used for modeling.
Either "lme4" or "asreml".}

\item{locationYear}{Should a model be fitted assuming a factorial structure
of locations x years?}

\item{nestingFactor}{A character string specifying a column in TD specifying
the nesting structure of the trials.}

\item{regionLocationYear}{Should a model be fitted assuming locations within
regions across years?}

\item{useWt}{Should the model be fitted using weights? Doing so requires a
column wt in the data. If \code{useWt = FALSE}, the default, and the data
contains no replicates, the last model term will be dropped and used as
homogeneous residual.}

\item{diagnostics}{Should diagnostics on missing combinations of model
variables be printed?}
}
\value{
An object of class \code{varComp}, a list containing:
\item{fitMod}{The fitted model.}
\item{modDat}{A data.frame containing the data used when fitting the model.}
\item{nestingFactor}{A name of the variable used as nesting variable in the
model.}
\item{useLocYear}{A boolean specifying if a model containing location x year
interaction was fitted.}
\item{fullRandVC}{A data.frame containing the variance components for the
fully random model.}
\item{aovFullMixedMod}{A data.frame containing the ANOVA table for the fully
fixed model.}
\item{engine}{The engine used for fitting the model.}
\item{diagTabs}{A list of data.frame, one for each random model term,
containing the missing combinations in the data for that term.}
}
\description{
This function fits a mixed model best fitting to the data in a TD object.
The exact model fitted is determined by both the structure of the genotype by
environment table of observations and the chosen parameters.\cr\cr
Six different types of models can be fitted depending on the structure of
the environments in the data. These models are described in the table below,
together with the function parameters used in \code{gxeVarComp} to fit the model.\tabular{lll}{
   Structure of environments \tab Model \tab Function parameters \cr
   Environments correspond to trials \tab \strong{trait} = trial + \strong{genotype + genotype:trial} \tab  \cr
   Trials form a factorial structure of locations x years \tab \strong{trait} = year + location + year:location + \strong{genotype + genotype:year + genotype:location + genotype:year:location} \tab \code{locationYear = TRUE} \cr
   Trials are nested within year \tab \strong{trait} = year + year:trial + \strong{genotype + genotype:year + genotype:year:trial} \tab \code{nestingFactor = "year"} \cr
   Trials are nested within locations \tab \strong{trait} = location + location:trial + \strong{genotype + genotype:location + genotype:location:trial} \tab \code{nestingFactor = "loc"} \cr
   Trials correspond to locations within regions across years \tab \strong{trait} = region + region:location + year + region:year + region:location:year + \strong{genotype + genotype:region + genotype:region:location + genotype:year + genotype:region:year + genotype:region:location:year} \tab \code{regionLocationYear = TRUE} \cr
   Trials are nested within scenarios \tab \strong{trait} = scenario + scenario:trial + \strong{genotype + genotype:scenario + genotype:scenario:trial} \tab \code{nestingFactor = "scenario"} \cr
}


In the models above the random part of the model is printed bold.\cr
For data in the form of GxE means, the last random term in all models above
will become a residual term. If the GxE means are provided together with
weights, then a residual term will be added to the models above.\cr\cr
The function first fits a model where all model terms are included as fixed
terms. Based on the ANOVA table of this model, terms in the fixed part of the
model that are likely to give a problem when fitting the mixed model are
removed because of the reduced connectivity and number of available
observations to estimate that model term. Also a warning is printed if the
mean sum of squares for a model term points to a possible zero variance
component in the mixed model.\cr\cr
Then a model is fitted where all model terms are included as random terms.
Based on the variance components in this model the percentage of variance
explained by each of the model components is determined. The percentages of
variance are printed in the model summary, together with the variance
components. The latter are presented on a standard deviation scale.\cr\cr
Finally a mixed model is fitted as specified in the overview above. Based on
this mixed model variance components can be computed using \code{\link{vc}},
heritabilies can be computed using \code{\link{herit}} and predictions can be
made using \code{\link{predict.varComp}}. Predictions of genotypic
performance can be made at the level of individual trials, or for groups of
trials by using \code{predictLevel}.
}
\examples{
## Fit a mixed model.
geVarComp <- gxeVarComp(TD = TDMaize, trait = "yld")

## Summarize results.
summary(geVarComp)

## Plot the standard deviations.
plot(geVarComp)

## Generate predictions
pred <- predict(geVarComp, predictLevel = "trial")
head(pred)

}
\seealso{
Other Mixed model analysis: 
\code{\link{CRDR}()},
\code{\link{correlations}()},
\code{\link{diagnostics}()},
\code{\link{herit}()},
\code{\link{plot.varComp}()},
\code{\link{predict.varComp}()},
\code{\link{vc}()}
}
\concept{Mixed model analysis}
