% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/revisit_rand.R
\name{revisit_rand}
\alias{revisit_rand}
\title{Create a revisit design with random assignment to panels and time periods}
\usage{
revisit_rand(
  n_period,
  n_pnl,
  rand_control = "period",
  n_visit,
  nsamp,
  panel_name = "Random",
  begin = 1,
  skip = 1
)
}
\arguments{
\item{n_period}{Number of time periods for the survey design. Typically,
number of periods if sampling occurs once per period or number of months if
sampling occurs once per month. (v, number of varieties (or treatments) in
BIBD terms)}

\item{n_pnl}{Number of panels}

\item{rand_control}{Character value must be \code{"none"}, \code{"panel"}, or \code{"period"}.
Specifies whether the number of sample events will be fixed for each panel
(\code{"panel"}), for each sample occasion (\code{"occasion"}), or for total panel-period
combinations (\code{"none"}).  Default is \code{"panel"}.}

\item{n_visit}{If \code{rand_control} is \code{"panel"}, this is the number of panels that
will be sampled in each time period. If rand_control is \code{"period"}, this is
the number of time periods to be sampled in each panel. If \code{rand_control} is
\code{"none"}, this is the total number of panel-period combinations that will
have units sampled in the revisit design.}

\item{nsamp}{Number of samples in each panel.}

\item{panel_name}{Prefix for name of each panel}

\item{begin}{Numeric name of first sampling occasion, e.g. a specific period.}

\item{skip}{Number of sampling occasions to skip between planned sampling
periods, e.g., sampling will occur only every 5 periods if \code{skip = 5}.}
}
\value{
A two-dimensional array of sample sizes to be sampled for each panel
  and each time period.
}
\description{
Create a revisit design for a survey that specifies the panels and time
periods that will be sampled by random selection of panels and time periods.
Three options for random assignments are \code{"period"} where the number of time
periods to be sampled in a panel is fixed, \code{"panel"} where the number panels to
be sampled in a time period is fixed, and \code{"none"} where the number of
panel-period combinations is fixed.
}
\details{
The revisit design for a survey is created by random selection of
  panels and time periods that will have sample events.  The number of sample
  occasions that will be visited by a panel is random.
}
\examples{
revisit_rand(
  n_period = 20, n_pnl = 10, rand_control = "none", n_visit = 50,
  nsamp = 20
)
revisit_rand(
  n_period = 20, n_pnl = 10, rand_control = "panel", n_visit = 5,
  nsamp = 10
)
revisit_rand(
  n_period = 20, n_pnl = 10, rand_control = "period",
  n_visit = 5, nsamp = 10
)
}
\seealso{
\describe{
    \item{\code{\link{revisit_bibd}}}{create a balanced incomplete block
      panel revisit design}
    \item{\code{\link{revisit_dsgn}}}{create a panel revisit design}
    \item{\code{\link{pd_summary}}}{ to summarize characteristics of a
      panel revisit design}
  }
}
\author{
Tony Olsen \email{Olsen.Tony@epa.gov}
}
\keyword{survey}
