% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/revisit_bibd.R
\name{revisit_bibd}
\alias{revisit_bibd}
\title{Create a balanced incomplete block panel revisit design}
\usage{
revisit_bibd(
  n_period,
  n_pnl,
  n_visit,
  nsamp,
  panel_name = "BIB",
  begin = 1,
  skip = 1,
  iter = 30
)
}
\arguments{
\item{n_period}{Number of time periods for the survey design. Typically,
number of periods if sampling occurs once per period or number of months if
sampling occurs once per month. (v, number of varieties/treatments in BIBD
terms)}

\item{n_pnl}{Number of panels (b, number of blocks in BIBD terms)}

\item{n_visit}{Number of time periods to be visited in a panel (k, block
size in BIBD terms)}

\item{nsamp}{Number of samples in each panel.}

\item{panel_name}{Prefix for name of each panel}

\item{begin}{Numeric name of first sampling occasion, e.g. a specific
period.}

\item{skip}{Number of sampling occasions to skip between planned sampling
periods, e.g., sampling will occur only every 5 periods if \code{skip = 5}.}

\item{iter}{Maximum number of iterations in search for D-optimal
Generalized Youden Design.}
}
\value{
A two-dimensional array of sample sizes to be sampled for each panel
  and each sampling occasion.
}
\description{
Create a revisit design for panels in a survey that specifies the time
periods for the units of each panel to be sampled based on searching for a
D-optimal block design that is a member of the class of generalized Youden
designs.  The resulting design need not be a balanced incomplete block
design.  Based on algorithmic idea by Cook and Nachtsheim (1989) and
implemented by Robert Wheeler.
}
\details{
The function uses \code{find.BIB} function from crossdes package to
search for a D-optimal block design.  crossdes uses package AlgDesign
to search balanced incomplete block designs.
}
\examples{
# Balanced incomplete block design with 20 sample occasions, 20 panels,
# 3 visits to each unit, and 20 units in each panel.
revisit_bibd(n_period = 20, n_pnl = 20, n_visit = 3, nsamp = 20)
}
\references{
Cook R. D.  and C. Nachtsheim. (1989). Computer-aided blocking of factorial
  and response-surface designs. \emph{Technometrics} \bold{31(3)}, 339-346.
}
\seealso{
\describe{
    \item{\code{\link{revisit_dsgn}}}{to create a panel revisit design}
    \item{\code{\link{revisit_rand}}}{to create a panel revisit design with random
      assignment to panels and time periods}
    \item{\code{\link{pd_summary}}}{ to summarize characteristics of a
      panel revisit design}
  }
}
\author{
Tony Olsen \email{Olsen.Tony@epa.gov}
}
\keyword{survey}
