% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.dsgn.R
\name{power.dsgn}
\alias{power.dsgn}
\title{Power Calculation for Multiple Panel Designs}
\usage{
power.dsgn(ind.names, ind.values, unit.var, period.var, unitperiod.var,
  index.var, unit.rho = 1, period.rho = 0, paneldsgn,
  nrepeats = NULL, trend.type = "mean", ind.pct = NULL,
  ind.tail = NULL, trend = 2, alpha = 0.05)
}
\arguments{
\item{ind.names}{Vector of indicator names}

\item{ind.values}{Vector of indicator mean values}

\item{unit.var}{Vector of variance component estimates for unit variability
for the indicators}

\item{period.var}{Vector of variance component estimates for period
variability for the indicators}

\item{unitperiod.var}{Vector of variance component estimates for unit by
period interaction variability for the indicators}

\item{index.var}{Vector of variance component estimates for index (residual)
error for the indicators}

\item{unit.rho}{Correlation across units. Default is 1}

\item{period.rho}{Correlation across periods. Default is 0}

\item{paneldsgn}{A list of panel designs each as a matrix.  Each element of
the list is a matrix with dimnames (dimensions: number of panels (rows) by
number of periods (columns)) containing the number of units visited for 
each combination of panel and period.  Dimnames for columns must be
convertable to an integer (e.g., 2016).  All designs must span the same
number of periods.  Typically, the panel designs are the output of the
function revisit_dsgn.}

\item{nrepeats}{Either NULL or a list of matrices the same length as
paneldsgn specifying the number of revisits made to units in a panel in the
same period for each design.  Specifying NULL indicates that number of
revisits to units is the same for all panels and for all periods and for
all panel designs. The default is NULL, a single visit. Names must match
list names in paneldsgn.}

\item{trend.type}{Trend type is either "mean" where trend is applied as
percent trend in the indicator mean or "percent" where the trend is applied
as percent trend in the proportion (percent) of the distribution that is
below or above a fixed value. Default is trend.type="mean"}

\item{ind.pct}{When trend.type is equal to "percent", a vector of the
values of the indicator fixed value that defines the percent.  Default is
NULL}

\item{ind.tail}{When trend.type is equal to "percent", a character vector
with values of either "lower" or "upper" for each indicator.  "lower"
states that the percent is associated with the lower tail of the
distribution and "upper" states that the percent is associated with the
upper tail of the distribution. Default is NULL.}

\item{trend}{Single value or vector of assumed percent change from
initial value in the indicator for each period. Assumes the trend is
expressed as percent per period. Note that the trend may be either positive
or negative. The default is trend=2.}

\item{alpha}{Single value or vector of significance level for linear
trend test, alpha, Type I error, level.  The defualt is 0.05.}
}
\value{
A list with components trend.type, ind.pct, ind.tail, trend values
  across periods, periods (all periods included in one or more panel
  designs), significance levels, a five-dimensional array of power
  calculations (dimensions: panel design names, periods, indicator names,
  trend names, alpha.names), an array of indicator mean values for each trend
  and the function call.
}
\description{
Calculates the power for trend detection for one or more variables, for one
or more panel designs, for one or more linear trends, and for one or more
signficance levels.  The panel designs create a covarance model where the
model includes variance components for units, periods, the interaction of
units and periods, and the residual (or index) variance.
}
\details{
Calculates the power for detecting a change in the mean for
  different panel design structures. The model incorporates unit, period,
  unit by period, and index variance components as well as correlation across
  units and across periods.  See references for methods.
}
\examples{
# Power for rotating panel with sample size 60
power.dsgn("Variable_Name", ind.values = 43, unit.var = 280, period.var = 4,
           unitperiod.var = 40, index.var = 90, unit.rho = 1, period.rho = 0,
           paneldsgn = list(NoR60=revisit_dsgn(20,
                            panels=list(NoR60=list(n=60, pnl_dsgn = c(1, NA),
                            pnl_n = NA, start_option = "None")), begin = 1)),
            nrepeats = NULL, trend.type = "mean", trend= 1.0, alpha=0.05)

}
\references{
Urquhart, N. S., W. S. Overton, et al. (1993) Comparing sampling designs
  for monitoring ecological status and trends: impact of temporal patterns.
  In: \emph{Statistics for the Environment.} V. Barnett and K. F. Turkman.
  John Wiley & Sons, New York, pp. 71-86.\cr

  Urquhart, N. S. and T. M. Kincaid (1999). Designs for detecting trends
  from repeated surveys of ecological resources. \emph{Journal of
  Agricultural, Biological, and Environmental Statistics}, \bold{4(4)},
  404-414.\cr

  Urquhart, N. S. (2012). The role of monitoring design in detecting trend in
  long-term ecological monitoring studies. In: \emph{Design and Analysis of
  Long-term Ecological Monitoring Studies.} R. A. Gitzen, J. J. Millspaugh,
  A. B. Cooper, and D. S. Licht (eds.). Cambridge University Press, New York,
  pp. 151-173.
}
\seealso{
\describe{
    \item{\code{\link{revisit_dsgn}}}{create a panel revisit design}
    \item{\code{\link{revisit_bibd}}}{create a balanced incomplete block
      panel revisit design}
    \item{\code{\link{revisit_rand}}}{create a revisit design with random
      assignment to panels and time periods}
    \item{\code{\link{panel_summary}}}{summarize characteristics of a revisit
      panel design}
    \item{\code{\link{cov.panel.dsgn}}}{covariance matrix for a panel design}
    \item{\code{\link{plot_powerpaneldesign}}}{plot power curves for panel
      designs}
  }
}
\author{
Tony Olsen \email{Olsen.Tony@epa.gov}
}
\keyword{survey}
