% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_powerpaneldesign.R
\name{plot_powerpaneldesign}
\alias{plot_powerpaneldesign}
\title{Plot Power Curves for Panel Designs}
\usage{
plot_powerpaneldesign(dsgnpower, plot.type = "standard",
  trend.type = "mean", xaxis.type = "period", comp.type = "design",
  dsgns = NULL, indicator = NULL, trend = NULL, period = NULL,
  alpha = NULL)
}
\arguments{
\item{dsgnpower}{List object of class powerpaneldesign. Object provides
power calculated for a set of panel designs, set of indicators, set of
trend values, and set of alpha values. Expect input as list as output from
function power.dsgn.}

\item{plot.type}{Default is "standard" which plots standard power curve. If
equal to "relative", then plot power of one panel design compared to one or
more other panel designs.}

\item{trend.type}{Character value for trend in mean ("mean") or or percent
change in proportion ("percent") of cumulative distribution function above
or below a fixed cut point.  Default is "mean".}

\item{xaxis.type}{Character value equal to "period" or "change" which
designates the type of x-axis for power plot where power is plotted on
y-axis.  For xaxis.type = "period", x-axis is periods in dsgnpower. If
xaxis.type = "change", then x-axis is percent per period with secondary
x-axises for total percent per period and associated change in mean.
Default is "period".  Note that xaxis.type controls how the input for
"period" and "trend" paramenters is used.}

\item{comp.type}{Character value equal to "design" or "Indicator" which
designates the type of power curve comparison that will occur on a single
plot.  If comp.type = "design", then on a single plot of power curves all
panel designs specified in "dsgns" are plotted for a single indicator,
single trend value and single alpha.  If comp.type = "indicator", then on a
single plot of power curves all indicators specified in "indicator" are
plotted for a single panel design, single trend value and single alpha.
Default is "design".}

\item{dsgns}{Vector of names of panel designs that are to be plotted.  Names
must be all, or a subset of, names of designs in dsgnpower. Default is NULL
which results in only the first panel design in dsgnpower being used.}

\item{indicator}{Vector of indicator names contained in dsgnpower that are
to be plotted.  Indicator names must be all, or a subset of, indicator
names in dsgnpower. Default is NULL which results in only the first
indicator in dsgnpower being used.}

\item{trend}{NULL, a single value or vector of values contained in dsgnpower
that will be plotted. Values must be all, or a subset of, trend values in
dsgnpower. If xaxis.type is equal to "period", then NULL results in maximum
trend value being used and a single value or vector of values results in a
separate plot for each value specified.  If xaxis.type is equal to
"change", then NULL results in all trend values in dsgnpower being plotted
on x-axis and a vector of values results in all trend values in dsgnpower
from minimum value to maximum value specified being plotted on x-axis.}

\item{period}{NULL, a single value or vector of values contained in dsgnpower
that will be plotted. Values must be all, or a subset of, period values in
dsgnpower. If xaxis.type is equal to "period", then NULL results in all
time periods in dsgnpower being plotted on x-axis and a vector of values
results in all period values in dsgnpower from minimum value to maximum
value specified being plotted on x-axis. If xaxis.type is equal to
"change", then NULL results in all time periods in dsgnpower being plotted
in separate plots and a vector of values results in time periods specified
being plotted in separate plots.}

\item{alpha}{A single value or vector of significance levels (as proportion,
e.g. 0.05) contained in dsgnpower to used for power plots. Specifying more
than a single value results in multiple plots. Default is NULL which
results in the minimum significance level in dsgnpower being used.}
}
\value{
One or more power curve plots are created and plotted.  User must
  specify output graphical device if more than one plot is created.  See
  Devices for graphical output options.
}
\description{
Plot power curves and relative power curves for trend detection for set of
panel designs, time periods, indicators, signifance levels and trend.  Trend
may be based on percent change per period in mean or percent change in
proportion of cumulative distribution function above or below a fixed cut
point. Types of plots are combinations of standard/relative, mean/percent,
period/change and design/indicator.  Input must be be of class
powerpaneldesign and is normally the output of function power.dsgn.
}
\details{
By default the plot function produces a standard power curve at end
  of each time period on the x-axis with y-axis as power. When more than one
  panel design is in dsgnpower, the first panel design is used When more than
  one indicatoris in dsgnpower, the first indicator is used  When more than
  one trend value is in dsgnpower, the maximum trend value is used. When more
  than one significance level, alpha, is in dsgnpower, the minimum
  significance level is used.

  Control of the type of plot produced is governed by plot.type, trend.type,
  xaxis.type and comp.type. The number of plots produced is governed by the
  number of panel designs (dsgn) specified, the number of indicators
  (indicator) specified, the number of time periods (period) specifice, the
  number of trend values (trend) specified and the number of significance
  levels (alpha) specified.

  When the comparison type ("comp.type") is equal to "design", all power
  curves specified by dsgn are plotted on the same plot.  When comp.type is
  equal to "indicator", all power curves specified by "indicator" are plotted
  on the same plot.  Typically, no more than 4-5 power curves should be
  plotted on same plot.
}
\examples{
# Construct a rotating panel design with sample size of 60
R60N <- revisit_dsgn (20, panels=list(R60N=list(n=60, pnl_dsgn = c(1, NA),
                      pnl_n=NA, start_option="None")), begin=1 )

# Construct a fixed panel design with sample size of 60
F60 <- revisit_dsgn (20, panels=list(F60=list(n=60, pnl_dsgn = c(1, 0),
                     pnl_n=NA, start_option="None")), begin=1 )

# Power for rotating panel with sample size 60
Power.tst <- power.dsgn("Variable_Name", ind.values = 43, unit.var = 280,
                        period.var = 4, unitperiod.var = 40, index.var = 90,
                        unit.rho = 1, period.rho = 0, paneldsgn = list(
                          R60N=R60N, F60=F60), nrepeats = NULL,
                        trend.type = "mean", trend= c(1.0, 2.0), alpha=0.05 )
plot_powerpaneldesign(Power.tst)
plot_powerpaneldesign(Power.tst, dsgns = c("F60", "R60N"))
plot_powerpaneldesign(Power.tst, dsgns = c("F60", "R60N"), trend = 1.0)
\dontrun{
pdf("Power.tst.pdf")
plot_powerpaneldesign(Power.tst, plot.type = "relative", comp.type = "design",
     trend.type = "mean", trend = c(1, 2), dsgns = c("R60N", "F60"),
     indicator="Variable_Name")
graphics.off()
}

}
\seealso{
\describe{
    \item{\code{\link{revisit_dsgn}}}{create a panel revisit design}
    \item{\code{\link{revisit_bibd}}}{create a balanced incomplete block
      panel revisit design}
    \item{\code{\link{revisit_rand}}}{create a revisit design with random
      assignment to panels and time periods}
    \item{\code{\link{panel_summary}}}{summarize characteristics of a revisit
      panel design}
    \item{\code{\link{power.dsgn}}}{power calculation for multiple panel
      designs}
    \item{\code{\link{cov.panel.dsgn}}}{covariance matrix for a panel design}
  }
}
\author{
Tony Olsen \email{Olsen.Tony@epa.gov}
}
\keyword{survey}
