% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grts.R
\name{grts}
\alias{grts}
\title{Select a Generalized Random-Tesselation Stratified (GRTS) Sample}
\usage{
grts(design, DesignID = "Site", SiteBegin = 1, type.frame = "finite",
  src.frame = "shapefile", in.shape = NULL, sf.object = NULL,
  sp.object = NULL, att.frame = NULL, id = NULL, xcoord = NULL,
  ycoord = NULL, stratum = NULL, mdcaty = NULL, startlev = NULL,
  maxlev = 11, maxtry = NULL, shift.grid = TRUE,
  do.sample = rep(TRUE, length(design)), shapefile = TRUE,
  prjfilename = NULL, out.shape = "sample.shp")
}
\arguments{
\item{design}{Named list of stratum design specifications which are also
lists.  Stratum names must be subset of values in stratum argument.  Each
stratum list has four components:
\describe{
  \item{panel}{named vector of sample sizes for each panel in stratum}
  \item{seltype}{the type of random selection, which must be one of
    following: "Equal" - equal probability selection, "Unequal" - unequal
    probability selection by the categories specified in caty.n and mdcaty,
    or "Continuous" - unequal probability selection proportional to
    auxiliary variable mdcaty}
  \item{caty.n}{if seltype equals "Unequal", a named vector of sample sizes
    for each category specified by mdcaty, where sum of the sample sizes
    must equal sum of the panel sample sizes, and names must be a subset of
    values in mdcaty}
  \item{over}{number of replacement sites ("oversample" sites) for the
    entire design, which is set equal to 0 if none are required)}
}
Example design for a stratified sample:\cr
  design=list(
    Stratum1=list(panel=c(PanelOne=50), seltype="Equal", over=10),
    Stratum2=list(panel=c(PanelOne=50, PanelTwo=50), seltype="Unequal",
      caty.n=c(CatyOne=25, CatyTwo=25, CatyThree=25, CatyFour=25),
      over=75))
Example design for an unstratified sample:\cr
  design <- list(
    None=list(panel=c(Panel1=50, Panel2=100, Panel3=50), seltype="Unequal",
      caty.n=c("Caty 1"=50, "Caty 2"=25, "Caty 3"=25, "Caty 4"=25,
      "Caty 5"=75), over=100))}

\item{DesignID}{Name for the design, which is used to create a site ID for
each site.  The default is "Site".}

\item{SiteBegin}{Number to use for first site in the design.  The default
is 1.}

\item{type.frame}{The type of frame, which must be one of following:
"finite", "linear", or "area".  The default is "finite".}

\item{src.frame}{Source of the frame, which equals "sf.object" if the frame
is contained in an sf package object, "shapefile" if the frame is to be
read from a shapefile, "sp.object" if the frame is obtained from an sp
package object, or "att.frame" if type.frame equals "finite" and the
frame is included in att.frame.  The default is "shapefile".}

\item{in.shape}{Name of a shapefile containing the frame, which is required
when src.frame equals "shapefile".  The shapefile name should include the
".shp" extension.  If the name does not include that extension, it will be
added.  The default is NULL.}

\item{sf.object}{An sf package object containing the frame, which is required
when src.frame equals "sf.object".  The default is NULL.}

\item{sp.object}{Name of the sp package object when src.frame equals
"sp.object". The default is NULL.}

\item{att.frame}{Data frame composed of attributes associated with elements
in the frame, which must contain the columns used for stratum and mdcaty
(if required).  If src.frame equals "shapefile" and att.frame equals NULL,
then att.frame is created from the dbf file(s) in the working directory. If
src.frame equals "sp.object" and att.frame equals NULL, then att.frame is
created from the sp object.  If src.frame equals "att.frame", then
att.frame must include columns that contain x-coordinates and y-coordinates
for each element in the frame.  The default is NULL.}

\item{id}{This argument is depricated.}

\item{xcoord}{Character string containing the name of the column from
att.frame that identifies x-coordinates when src.frame equals "att.frame".
If xcoord equals NULL, then xcoord is given the value "x".  The default is
NULL.}

\item{ycoord}{Character string containing the name of the column from
att.frame that identifies y-coordinates when src.frame equals "att.frame".
If ycoord equals NULL, then ycoord is given the value "y".  The default is
NULL.}

\item{stratum}{Character string containing the name of the column from
att.frame that identifies stratum membership for each element in the frame.
If stratum equals NULL, the design is unstratified, and a column named
"stratum" (with all of its elements equal to the stratum name specified in
design) is added to att.frame.  The default is NULL.}

\item{mdcaty}{Character string containing the name of the column from
att.frame that identifies the unequal probability category for each element
in the frame.  The default is NULL.}

\item{startlev}{Initial number of hierarchical levels to use for the GRTS
grid, which must be less than or equal to maxlev (if maxlev is specified)
and cannot be greater than 11.  The default is NULL.}

\item{maxlev}{Maxmum number of hierarchical levels to use for the GRTS
grid, which cannot be greater than 11.  The default is 11.}

\item{maxtry}{This argument is depricated.}

\item{shift.grid}{Option to randomly shift the hierarchical grid, where
TRUE means shift the grid and FALSE means do not shift the grid, which is
useful if one desires strict spatial stratification by hierarchical grid
cells.  The default is TRUE.}

\item{do.sample}{Named vector that provides the option controlling sample
selection for each stratum, where TRUE means select a sample from a stratum
and FALSE means return the sample frame for a stratum in reverse
hierarchical order.  Note that FALSE can only be used when type.frame
equals "points" and seltype equals "Equal".  Names for the vector must
match the names in design.  If the vector is not named, then the names in
design are used.  The default is TRUE for each stratum.}

\item{shapefile}{Option to create a shapefile containing the survey design
information,  where TRUE equals create a shapefile and FALSE equals do not
create a shapefile.  The default is TRUE.}

\item{prjfilename}{This argument is depricated.}

\item{out.shape}{Name of the output shapefile.  The default is "sample.shp".}
}
\value{
An object of class SpatialDesign containing the survey design
  information and any additional attribute variables that were provided.
  Optionally, a shapefile can be created that contains the survey design
  information.
}
\description{
This function select a GRTS sample of a finite, linear, or area resource.
Frame elements must be located in 1- or 2-dimensional coordinate system.
Random selection may be generalized random tessellation stratified (GRTS),
independent random sample (IRS), or systematic sample.  Sample may be equal
probability or unequal probability (either categorical or proportional to
auxiliary variable).  May designate panels of sites for surveys over time.
}
\section{Other Functions Required}{

  \describe{
    \item{\code{\link{grtsarea}}}{select a GRTS sample of an area resource}
    \item{\code{\link{grtslin}}}{select a GRTS sample of a linear resource}
    \item{\code{\link{grtspts}}}{select a GRTS sample of a finite resource}
    \item{\code{\link{SpatialPoints}}}{sp package function to create an
      object of class SpatialPoints}
    \item{\code{\link{SpatialPointsDataFrame}}}{sp package function to create
      an object of class SpatialPointsDataFrame}
  }
}

\examples{
\dontrun{
  test_design <- list(
    Stratum1=list(panel=c(PanelOne=50), seltype="Equal", over=10),
    Stratum2=list(panel=c(PanelOne=50, PanelTwo=50), seltype="Unequal",
      caty.n=c(CatyOne=25, CatyTwo=25, CatyThree=25, CatyFour=25), over=75))
  test.sample <- grts(design=test_design, DesignID="TestSite",
    type.frame="area", src.frame="shapefile", in.shape="test_shapefile.shp",
    stratum="test_stratum", mdcaty="test_mdcaty", shapefile=TRUE,
    out.shape="test_sample.shp")
}

}
\author{
Tom Kincaid  email{Kincaid.Tom@epa.gov}
}
\keyword{survey}
