%     The spsmooth R package
%     An extension for mgcv.
%     Copyright (C) 2012 Wesley Burr
%
%     Written by Wesley Burr.
%
%     This file is part of the spsmooth package for R.
%
%     The spsmooth package is free software: you can redistribute it and
%     or modify it under the terms of the GNU General Public License as 
%     published by the Free Software Foundation, either version 2 of the 
%     License, or any later version.
%
%     The spsmooth package is distributed in the hope that it will be 
%     useful, but WITHOUT ANY WARRANTY; without even the implied warranty 
%     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%     GNU General Public License for more details.
%
%     You should have received a copy of the GNU General Public License
%     along with spsmooth.  If not, see <http://www.gnu.org/licenses/>.
%
%     If you wish to report bugs please contact the author. 
%     Wesley Burr
%     wburr@mast.queensu.ca
%     239 Jeffery Hall, Queen's University, Kingston, Ontario
%     Canada, K7L 3N6

\name{Predict.matrix.sp.smooth}
\alias{Predict.matrix.sp.smooth}
\title{ Constructor for predict matrix object.  }
\description{ Constructs prediction matrix for smooth classes used in 
    \code{\link[mgcv]{gam}}, specifically by summary and predict.
}
\usage{
    \method{Predict.matrix}{sp.smooth}(object, data)  
}
\arguments{
  \item{object}{
      Object should be a \code{\link[mgcv]{gam}} smooth object, 
      containing non-standard list elements 'mask' and 'W'. This
      object is usually constructed by a 
      \code{\link[mgcv]{smooth.construct}} method having processed a 
      smooth specification object generated by an
      \code{\link[mgcv]{s}} term in a \code{\link[mgcv]{gam}} 
      formula.
}
  \item{data}{
      A data frame containing the values of the named (time) covariate
      at which the smooth term is to be evaluated. Just as in 
      \code{\link{smooth.construct}}, 
      if data does not consist of a contiguous index series (in time), 
      element 'mask' must be included as part of object. This is done
      by including xt=c() as a parameter to the 's' function call. See
      the examples below.
}
}
\details{
    Requires that summary compute standard errors using frequentist 
    approach, i.e. that the full original data set including missing
    values (tagged as NA) be passed. This is accomplished in practice
    by calling \code{summary.gam} as 
    \code{\link[mgcv]{summary.gam}(object, p.type=5, freq=TRUE)}. This
    is accomplished in this package by overloading the \code{summary.gam}
    function, so the user should not have to worry about this.

    This function is not intended to be called directly by the user.
}
\value{
    A matrix mapping the coeffients for the smooth term to its 
    values at the supplied data values. Consists explicitly of an
    augmented Slepian basis matrix, subselected to the elements \code{!is.na(object$data)}.
}
\references{
Wood S.N. (2006) Generalized Additive Models: An Introduction with R. Chapman
and Hall/CRC Press.

Wood, S.N. (2011) Fast stable restricted maximum likelihood and marginal likelihood 
estimation of semiparametric generalized linear models. Journal of the Royal 
Statistical Society - Series B (Applied Statistics), 73(1), 3-36.

Hastie, T.J. & Tibshirani, R.J. (1990) Generalized Additive Models. 
Chapman and Hall.
}
\author{
    Wesley Burr \email{wburr@mast.queensu.ca}
}
\keyword{ smooth } \keyword{ models } \keyword{ regression }
