% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample.R
\name{resample.uniform}
\alias{resample.uniform}
\title{Draw uniform random (sub)sample}
\usage{
resample.uniform(data, param = list(n = Inf, replace = FALSE))
}
\arguments{
\item{data}{a \code{data.frame}, rows represent samples}

\item{param}{a list with the following components: \code{n} is a numeric
value specifying the size of the subsample; \code{replace} determines if
sampling is with or without replacement}
}
\value{
a \code{data.frame} containing a subset of the rows of \code{data}.
}
\description{
\code{resample.uniform} draws a random (sub)sample
(with or without replacement) from the samples in \code{data}.
}
\details{
If \code{param$replace=FALSE}, a subsample of size
\code{min(param$n,nrow(data))} will be drawn from \code{data}.
If \code{param$replace=TRUE}, the size of the subsample is \code{param$n}.
}
\examples{
data(ecuador) # Muenchow et al. (2012), see ?ecuador
d = resample.uniform(ecuador, param = list(strat = 'slides', n = 200))
nrow(d) # == 200
sum(d$slides == 'TRUE')

}
\seealso{
\code{\link[=resample.strat.uniform]{resample.strat.uniform()}}, \code{\link[=sample]{sample()}}
}
