/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.support;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.support.PlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderListItemConverter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.support.StrategyPlaceholderListItemConverter;
import bibliothek.util.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DockablePlaceholderList<P extends PlaceholderListItem<Dockable>>
extends PlaceholderList<Dockable, DockStation, P> {
    public DockablePlaceholderList() {
    }

    public DockablePlaceholderList(PlaceholderMap map) {
        this(map, new StrategyPlaceholderListItemConverter(null));
    }

    public DockablePlaceholderList(PlaceholderMap map, PlaceholderListItemConverter<Dockable, P> converter) {
        super(map, converter);
    }

    public static <P extends PlaceholderListItem<Dockable>> void simulatedRead(PlaceholderMap map, PlaceholderListItemConverter<Dockable, P> converter) {
        DockablePlaceholderList<P> list = new DockablePlaceholderList<P>();
        list.read(map, converter, true);
    }

    public PlaceholderMap toMap() {
        return this.toMap(new StrategyPlaceholderListItemConverter(this.getStrategy()));
    }

    @Override
    protected Path getPlaceholder(Dockable dockable) {
        PlaceholderStrategy strategy = this.getStrategy();
        if (strategy != null) {
            return strategy.getPlaceholderFor(dockable);
        }
        return null;
    }

    @Override
    protected DockStation toStation(Dockable dockable) {
        return dockable.asDockStation();
    }

    protected Dockable[] getChildren(DockStation station) {
        Dockable[] children = new Dockable[station.getDockableCount()];
        for (int i = 0; i < children.length; ++i) {
            children[i] = station.getDockable(i);
        }
        return children;
    }

    @Override
    protected PlaceholderMap getPlaceholders(DockStation station) {
        return station.getPlaceholders();
    }

    @Override
    protected void setPlaceholders(DockStation station, PlaceholderMap map) {
        station.setPlaceholders(map);
    }

    @Override
    protected String toString(Dockable dockable) {
        return "'" + dockable.getTitleText() + "'";
    }
}

