/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.event.DockableAdapter;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.station.DisplayerCollection;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.title.DockTitleVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StationChildHandle
implements PlaceholderListItem<Dockable> {
    private DockStation station;
    private Dockable dockable;
    private DisplayerCollection displayers;
    private DockableDisplayer displayer;
    private DockTitleRequest titleRequest;
    private DockableListener listener = new DockableAdapter(){

        public void titleExchanged(Dockable dockable, DockTitle title) {
            if (dockable == StationChildHandle.this.dockable && StationChildHandle.this.displayer != null && StationChildHandle.this.displayer.getTitle() == title) {
                StationChildHandle.this.requestTitle();
            }
        }
    };

    public StationChildHandle(DockStation station, DisplayerCollection displayers, Dockable dockable, DockTitleVersion title) {
        this.station = station;
        this.displayers = displayers;
        this.dockable = dockable;
        dockable.addDockableListener(this.listener);
        this.setTitleRequest(title, false);
    }

    public void destroy() {
        if (this.displayer != null) {
            DockTitle title = this.displayer.getTitle();
            if (title != null) {
                this.dockable.unbind(title);
            }
            this.displayers.release(this.displayer);
            this.displayer = null;
        }
        if (this.titleRequest != null) {
            this.titleRequest.uninstall();
            this.titleRequest = null;
        }
        this.dockable.removeDockableListener(this.listener);
    }

    public void updateDisplayer() {
        DockTitle title = null;
        if (this.displayer != null) {
            title = this.displayer.getTitle();
            this.displayers.release(this.displayer);
        } else if (this.titleRequest != null) {
            this.titleRequest.request();
            title = this.titleRequest.getAnswer();
            if (title != null) {
                this.dockable.bind(title);
            }
        }
        this.displayer = this.displayers.fetch(this.dockable, title);
    }

    public DockableDisplayer getDisplayer() {
        return this.displayer;
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    @Override
    public Dockable asDockable() {
        return this.getDockable();
    }

    public DockTitle getTitle() {
        if (this.titleRequest == null) {
            return null;
        }
        return this.titleRequest.getAnswer();
    }

    public void setTitleRequest(DockTitleVersion version) {
        this.setTitleRequest(version, true);
    }

    public void setTitleRequest(DockTitleVersion version, boolean request) {
        if (this.titleRequest != null) {
            this.titleRequest.uninstall();
            this.titleRequest = null;
            DockTitle title = this.displayer.getTitle();
            if (title != null) {
                this.displayer.getDockable().unbind(title);
                this.displayer.setTitle(null);
            }
        }
        if (version != null) {
            this.titleRequest = new DockTitleRequest(this.station, this.dockable, version){

                protected void answer(DockTitle old, DockTitle title) {
                    if (StationChildHandle.this.displayer != null) {
                        DockTitle oldTitle = StationChildHandle.this.displayer.getTitle();
                        if (oldTitle != null) {
                            StationChildHandle.this.dockable.unbind(oldTitle);
                        }
                        if (title != null) {
                            StationChildHandle.this.dockable.bind(title);
                        }
                        StationChildHandle.this.displayer.setTitle(title);
                    }
                }
            };
        }
        if (this.titleRequest != null) {
            this.titleRequest.install();
            if (request) {
                this.titleRequest.request();
            }
        }
    }

    public void requestTitle() {
        if (this.titleRequest != null) {
            this.titleRequest.request();
        }
    }
}

